/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.cash.currency;

import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.currency.CurrencySum;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.currency.CurrencyRate;
import ru.softlogic.reference.currency.ProviderCurrencyRate;

public class CurrencyUtil {
    private static final ResourceBundle currencyLocaleBundle = ResourceBundle.getBundle("ru.softlogic.cash.currency.locales");

    public static Double getRate(String currency, int sid) {
        if (currency == null) {
            return 1.0;
        }
        try {
            CurrencyRate cr;
            int i;
            CurrencyRate[] rates = ReferenceManager.getInstance().getCurrencyRates();
            if (rates == null || rates.length == 0) {
                return null;
            }
            Date now = new Date();
            for (i = rates.length - 1; i >= 0; --i) {
                cr = rates[i];
                if (!cr.getCurrency().equals(currency) || !cr.getFrom().before(now) || cr.getServiceId() == null || cr.getServiceId() != sid) continue;
                return cr.getRate() / (double)cr.getNominal();
            }
            for (i = rates.length - 1; i >= 0; --i) {
                cr = rates[i];
                if (!cr.getCurrency().equals(currency) || cr.getServiceId() != null || !cr.getFrom().before(now)) continue;
                return cr.getRate() / (double)cr.getNominal();
            }
            return null;
        }
        catch (ReferenceException ex) {
            return null;
        }
    }

    public static CurrencySum getCross(String currency, int sid, Sum out) {
        Double rate = CurrencyUtil.getRate(currency, sid);
        if (rate == null) {
            return null;
        }
        if (currency == null) {
            currency = SystemProp.getCurrency();
        }
        if (currency == null) {
            currency = "RUB";
        }
        try {
            ProviderCurrencyRate cr;
            int i;
            ProviderCurrencyRate[] rates = ReferenceManager.getInstance().getProviderCurrencyRates();
            if (rates == null || rates.length == 0) {
                return null;
            }
            Date now = new Date();
            for (i = rates.length - 1; i >= 0; --i) {
                cr = rates[i];
                if (!cr.getBaseCurrency().equals(currency) || !cr.getFrom().before(now) || cr.getServiceId() == null || cr.getServiceId() != sid) continue;
                return new CurrencySum(out.div(rate).div(cr.getRate() / (double)cr.getNominal()), CurrencyUtil.getCurrencyLocale(cr.getCurrency()));
            }
            for (i = rates.length - 1; i >= 0; --i) {
                cr = rates[i];
                if (!cr.getBaseCurrency().equals(currency) || cr.getServiceId() != null || !cr.getFrom().before(now)) continue;
                return new CurrencySum(out.div(rate).div(cr.getRate() / (double)cr.getNominal()), CurrencyUtil.getCurrencyLocale(cr.getCurrency()));
            }
            return null;
        }
        catch (ReferenceException ex) {
            return null;
        }
    }

    public static Locale getCurrencyLocale(String currency) {
        try {
            String locale = currencyLocaleBundle.getString(currency);
            return new Locale(locale.substring(0, 2), locale.substring(3, 5));
        }
        catch (Exception ex) {
            return null;
        }
    }
}

