/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.cash;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.cash.unit.CashUnit;

public class Keeper
implements Serializable {
    static final long serialVersionUID = -2239565873386617678L;
    private final Map<CashUnit, Integer> cashUnits = new HashMap<CashUnit, Integer>();
    private final List<CashBackCard> cashBackCards = new LinkedList<CashBackCard>();
    private Sum sum = new Sum();
    private Date created = new Date();

    public final synchronized void addPayback(Sum payback) {
        int k2;
        int m = payback.getBasicSum();
        int k1 = m / 100000;
        if (k1 > 0) {
            this.addCash(new CashUnit(1002, new Sum(1000.0), 2), k1);
            m -= k1 * 100000;
        }
        if ((k2 = m / 100) > 0) {
            this.addCash(new CashUnit(1001, new Sum(1.0), 2), k2);
            m -= k2 * 100;
        }
        if (m > 0) {
            this.addCash(new CashUnit(1000, new Sum(0.01), 2), m);
        }
    }

    public final synchronized void addCash(CashUnit cu) {
        this.addCash(cu, 1);
    }

    public void addCash(CashUnit cu, int count) {
        this.sum = this.sum.add(cu.getNominal().mul(count));
        if (this.cashUnits.containsKey(cu)) {
            Integer value = this.cashUnits.get(cu);
            this.cashUnits.put(cu, value + count);
        } else {
            this.cashUnits.put(cu, count);
        }
    }

    public final synchronized void removeCash(CashUnit cu) {
        this.removeCash(cu, 1);
    }

    public final synchronized void removeCash(CashUnit cu, int count) {
        this.sum = this.sum.sub(cu.getNominal().mul(count));
        if (this.cashUnits.containsKey(cu)) {
            Integer value = this.cashUnits.get(cu);
            this.cashUnits.put(cu, value - count);
        } else {
            this.cashUnits.put(cu, -count);
        }
    }

    public final synchronized void addCashBackCard(CashBackCard cbc) {
        this.sum = this.sum.add(cbc.getNominal());
        this.cashBackCards.add(cbc);
    }

    public final synchronized List<CashBackCard> getCashBackCards() {
        return Collections.unmodifiableList(this.cashBackCards);
    }

    public final synchronized Map<CashUnit, Integer> getCashUnits() {
        return this.cashUnits;
    }

    public final synchronized Sum getSum() {
        return this.sum;
    }

    public synchronized Sum getCashSum() {
        Sum res = new Sum();
        for (CashUnit cu : this.cashUnits.keySet()) {
            if (cu.getType() == 2) continue;
            res = res.add(cu.getNominal().mul(this.cashUnits.get(cu)));
        }
        return res;
    }

    public synchronized Sum getCashlessSum() {
        Sum res = new Sum();
        for (CashUnit cu : this.cashUnits.keySet()) {
            if (cu.getType() != 2) continue;
            res = res.add(cu.getNominal().mul(this.cashUnits.get(cu)));
        }
        for (CashBackCard cbc : this.cashBackCards) {
            res = res.add(cbc.getNominal());
        }
        return res;
    }

    public synchronized Sum getVirtualSum() {
        Sum res = new Sum();
        for (CashUnit cu : this.cashUnits.keySet()) {
            if (cu.getType() != 2) continue;
            res = res.add(cu.getNominal().mul(this.cashUnits.get(cu)));
        }
        return res;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String toString() {
        return "Keeper[CashUnits: " + this.cashUnits + " CashBackCards" + this.cashBackCards + "]";
    }
}

