/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.cash;

import java.util.HashMap;
import java.util.Map;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.cash.CashResource;
import ru.softlogic.cash.CashResource_AED;
import ru.softlogic.cash.CashResource_AZN;
import ru.softlogic.cash.CashResource_BGN;
import ru.softlogic.cash.CashResource_CNY;
import ru.softlogic.cash.CashResource_COP;
import ru.softlogic.cash.CashResource_CRC;
import ru.softlogic.cash.CashResource_EUR;
import ru.softlogic.cash.CashResource_EUR2;
import ru.softlogic.cash.CashResource_KGS;
import ru.softlogic.cash.CashResource_KZT;
import ru.softlogic.cash.CashResource_MAD;
import ru.softlogic.cash.CashResource_MXP;
import ru.softlogic.cash.CashResource_NGN;
import ru.softlogic.cash.CashResource_NPR;
import ru.softlogic.cash.CashResource_PHP;
import ru.softlogic.cash.CashResource_RON;
import ru.softlogic.cash.CashResource_RUB;
import ru.softlogic.cash.CashResource_TJS;
import ru.softlogic.cash.CashResource_TMT;
import ru.softlogic.cash.CashResource_TRY;
import ru.softlogic.cash.CashResource_UAH;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.cash.unit.CashUnit;

public class CashFactory
implements CashResource {
    private static final Map<String, CashFactory> resources = new HashMap<String, CashFactory>();
    private CashResource resource;

    public CashFactory(String currency) {
        if (currency == null || currency.equals("RUB") || currency.equals("RU") || currency.equals("RUR")) {
            this.resource = new CashResource_RUB();
        } else if (currency.equals("KZT") || currency.equals("KZ")) {
            this.resource = new CashResource_KZT();
        } else if (currency.equals("CNY")) {
            this.resource = new CashResource_CNY();
        } else if (currency.equals("UAH")) {
            this.resource = new CashResource_UAH();
        } else if (currency.equals("BGN")) {
            this.resource = new CashResource_BGN();
        } else if (currency.equals("COP")) {
            this.resource = new CashResource_COP();
        } else if (currency.equals("EUR") || currency.equals("EU")) {
            this.resource = new CashResource_EUR();
        } else if (currency.equals("EUR2")) {
            this.resource = new CashResource_EUR2();
        } else if (currency.equals("MAD") || currency.equals("MA")) {
            this.resource = new CashResource_MAD();
        } else if (currency.equals("TJS")) {
            this.resource = new CashResource_TJS();
        } else if (currency.equals("MXP") || currency.equals("MX") || currency.equals("MXN")) {
            this.resource = new CashResource_MXP();
        } else if (currency.equals("PHP") || currency.equals("PH")) {
            this.resource = new CashResource_PHP();
        } else if (currency.equals("KGS") || currency.equals("KG")) {
            this.resource = new CashResource_KGS();
        } else if (currency.equals("TRY") || currency.equals("TR")) {
            this.resource = new CashResource_TRY();
        } else if (currency.equals("NPR") || currency.equals("NP")) {
            this.resource = new CashResource_NPR();
        } else if (currency.equals("RON") || currency.equals("RO") || currency.equals("ROM")) {
            this.resource = new CashResource_RON();
        } else if (currency.equals("AED") || currency.equals("AE")) {
            this.resource = new CashResource_AED();
        } else if (currency.equals("TMT")) {
            this.resource = new CashResource_TMT();
        } else if (currency.equals("NGN")) {
            this.resource = new CashResource_NGN();
        } else if (currency.equals("CRC") || currency.equals("CR")) {
            this.resource = new CashResource_CRC();
        } else if (currency.equals("AZN") || currency.equals("AZ")) {
            this.resource = new CashResource_AZN();
        } else {
            throw new IllegalArgumentException("\u0412\u0430\u043b\u044e\u0442\u0430 " + currency + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        }
    }

    public static synchronized CashFactory getInstance(String currency) {
        CashFactory instance = resources.get(currency);
        if (instance == null) {
            try {
                instance = new CashFactory(currency);
                resources.put(currency, instance);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return instance;
    }

    public static CashFactory getDefaultInstance() {
        return CashFactory.getInstance(SystemProp.getCurrency());
    }

    @Override
    public final CashUnit[] getCashUnits() {
        return this.resource.getCashUnits();
    }

    public final CashUnit getCashUnitByNominal(Sum nominal) {
        CashUnit[] units;
        for (CashUnit cu : units = this.getCashUnits()) {
            if (!cu.getNominal().equals(nominal)) continue;
            return cu;
        }
        return null;
    }

    public final CashUnit getCoinUnitByNominal(Sum nominal) {
        CashUnit[] units = this.getCoinUnits();
        if (units != null) {
            int sf = this.resource.getCoinScaleFactor();
            if (sf != 1) {
                nominal = nominal.mul(sf);
            }
            for (CashUnit cu : units) {
                if (!cu.getNominal().equals(nominal)) continue;
                return cu;
            }
        }
        return null;
    }

    @Override
    public final CashBackCard getCashBackCard() {
        return this.resource.getCashBackCard();
    }

    @Override
    public final String getCurrency() {
        return this.resource.getCurrency();
    }

    @Override
    public CashUnit[] getCoinUnits() {
        return this.resource.getCoinUnits();
    }

    @Override
    public int getCoinScaleFactor() {
        return 1;
    }
}

