/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.session;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.state.PaymentTemplateState;
import ru.softlogic.cash.Keeper;
import ru.softlogic.operation.Operation;
import ru.softlogic.system.util.FileUtil;

public class Session
implements Serializable {
    static final long serialVersionUID = -4495148522818657247L;
    private static Session instance;
    private Pack pack = new Pack();
    private Keeper currentKeeper;
    private Operation lastPayment;
    private Date changeDate;
    private Pack lastPack;
    private Pack correctPack;
    private boolean paymentAddedToQueue;
    private boolean onlinePaymentStart;
    private PaymentTemplateState paymentTemplateState;
    private static final Logger log;

    private Session() {
    }

    public static synchronized Session getInstance() {
        if (instance == null) {
            instance = Session.readData();
        }
        return instance;
    }

    public Pack getPack() {
        return this.pack;
    }

    public void setPack(Pack pack) {
        if (pack == null) {
            throw new IllegalArgumentException("Pack cant be null");
        }
        this.pack = pack;
        this.flush();
    }

    public Pack getCorrectPack() {
        return this.correctPack;
    }

    public void setCorrectPack(Pack correctPack) {
        this.correctPack = correctPack;
        this.flush();
    }

    public Keeper getCurrentKeeper() {
        return this.currentKeeper;
    }

    public void setCurrentKeeper(Keeper currentKeeper) {
        this.currentKeeper = currentKeeper;
        this.flush();
    }

    public Operation getLastPayment() {
        return this.lastPayment;
    }

    public void setLastPayment(Operation lastPayment) {
        this.lastPayment = lastPayment;
    }

    public Date getChangeDate() {
        return this.changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public Pack getLastPack() {
        return this.lastPack;
    }

    public void setLastPack(Pack lastPack) {
        this.lastPack = lastPack;
    }

    public boolean isPaymentAddedToQueue() {
        return this.paymentAddedToQueue;
    }

    public void setPaymentAddedToQueue(boolean paymentAddedToQueue) {
        this.paymentAddedToQueue = paymentAddedToQueue;
        this.flush();
    }

    public boolean isOnlinePaymentStart() {
        return this.onlinePaymentStart;
    }

    public void setOnlinePaymentStart(boolean onlinePaymentStart) {
        this.onlinePaymentStart = onlinePaymentStart;
    }

    public PaymentTemplateState getPaymentTemplateState() {
        if (this.paymentTemplateState == null) {
            this.paymentTemplateState = new PaymentTemplateState();
            this.flush();
        }
        return this.paymentTemplateState;
    }

    private static Session readData() {
        log.setAdditivity(false);
        log.info((Object)"*************** \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0447\u0442\u0435\u043d\u0438\u0435 \u0441\u0435\u0441\u0441\u0438\u043e\u043d\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 ***************");
        ObjectInputStream ois = null;
        Session s = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(FileUtil.checkFile((String)(SystemProp.getTerminalDir() + File.separator + "data" + File.separator + "session.obj"))));
            Object obj = ois.readObject();
            if (obj instanceof Session) {
                s = (Session)obj;
            }
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception ex) {
                    System.out.println(ex);
                }
            }
        }
        if (s == null) {
            s = new Session();
        }
        log.info((Object)"********************* \u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b \u0447\u0442\u0435\u043d\u0438\u0435 *********************");
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ObjectOutputStream oos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(FileUtil.checkFile((String)(SystemProp.getTerminalDir() + File.separator + "data" + File.separator + "session.obj")));
            fos.getChannel().force(true);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(this);
            fos.flush();
            fos.getFD().sync();
        }
        catch (Exception ex) {
            log.setAdditivity(false);
            log.error((Object)ex, (Throwable)ex);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    static {
        log = Logger.getLogger((String)"app");
    }
}

