/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.session;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.system.util.FileUtil;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ServiceZReportStorage", namespace="http://soft-logic.ru")
public class ServiceZReportStorage
implements Serializable {
    static final long serialVersionUID = 5725861841002378133L;
    private static ServiceZReportStorage instance;
    @XmlElementWrapper(name="snapshots")
    @XmlElement(name="snapshot")
    private LinkedList<ServiceZReportSnapshot> snapshots = new LinkedList();
    @XmlAttribute(name="currentSnapshot")
    private ServiceZReportSnapshot currentSnapshot = new ServiceZReportSnapshot();
    @XmlAttribute(name="customTimeInterval")
    private long timeInterval = 0L;
    @XmlAttribute(name="timeSnapshot")
    private int timeSnapshot = 0;
    private static final Logger log;

    public static synchronized ServiceZReportStorage getInstance() {
        if (instance == null) {
            instance = ServiceZReportStorage.readZReportData();
        }
        return instance;
    }

    public void setTimeInterval(long customTimeInterval) {
        this.timeInterval = customTimeInterval;
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public int getTimeSnapshot() {
        return this.timeSnapshot;
    }

    public void setTimeSnapshot(int ntimeSnapshot) {
        this.timeSnapshot = ntimeSnapshot;
    }

    public ServiceZReportSnapshot getCurrentSnapshot() {
        return this.currentSnapshot;
    }

    public List<ServiceZReportSnapshot> getSnapshots() {
        return this.snapshots;
    }

    public void saveCurrentSnapshot() {
        try {
            log.info((Object)"saveCurrentSnapshot");
            this.currentSnapshot.saveAll();
            this.snapshots.add(this.currentSnapshot);
            ServiceZReportSnapshot oldSnap = this.currentSnapshot;
            this.currentSnapshot = new ServiceZReportSnapshot(oldSnap);
            this.flushZReport();
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
        }
    }

    public void setCurrentMCSum(Keeper cashBoxKeeper, Keeper coinBoxKeeper) {
        this.currentSnapshot.setCurrentMCSum(cashBoxKeeper, coinBoxKeeper);
    }

    public void clearAllSnapshots() {
        try {
            this.snapshots = null;
            this.snapshots = new LinkedList();
            this.flushZReport();
            log.info((Object)("clearAllSnapshots: currentSnapshot = " + this.currentSnapshot.toMap()));
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceZReportStorage readZReportData() {
        log.setAdditivity(false);
        log.info((Object)"*************** \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0447\u0442\u0435\u043d\u0438\u0435 \u0441\u0435\u0441\u0441\u0438\u043e\u043d\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 ***************");
        ServiceZReportStorage s = null;
        try {
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(FileUtil.checkFile((String)(SystemProp.getTerminalDir() + File.separator + "data" + File.separator + "servicezreport.obj"))));){
                Object obj = ois.readObject();
                if (obj instanceof ServiceZReportStorage) {
                    s = (ServiceZReportStorage)obj;
                }
            }
            log.info((Object)("readZReportData = " + s));
            if (s == null) {
                s = new ServiceZReportStorage();
                s.flushZReport();
            }
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
        }
        finally {
            log.info((Object)("readZReportData = " + s));
            if (s == null) {
                s = new ServiceZReportStorage();
                s.flushZReport();
            }
        }
        log.info((Object)"********************* \u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b \u0447\u0442\u0435\u043d\u0438\u0435 *********************");
        return s;
    }

    public void flushZReport() {
        try (FileOutputStream fos = new FileOutputStream(FileUtil.checkFile((String)(SystemProp.getTerminalDir() + File.separator + "data" + File.separator + "servicezreport.obj")));
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            fos.getChannel().force(true);
            oos.writeObject(this);
            fos.flush();
            fos.getFD().sync();
            log.info((Object)"flushZReport success");
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
        }
    }

    static {
        log = Logger.getLogger((String)"print");
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="ServiceZReportSnapshot", namespace="http://soft-logic.ru")
    public class ServiceZReportSnapshot
    implements Serializable {
        private static final long serialVersionUID = -7979951779213464156L;
        @XmlAttribute(name="createdDate")
        private Date createdDate = new Date();
        @XmlAttribute(name="cashKeeper")
        private Keeper cashKeeper;
        @XmlAttribute(name="coinKeeper")
        private Keeper coinKeeper;
        @XmlAttribute(name="cashboxallmc")
        private Sum cashBoxAllMoneyCollectionSum = new Sum(0);
        @XmlAttribute(name="cashlessboxallmc")
        private Sum cashlessBoxAllMoneyCollectionSum = new Sum(0);
        @XmlAttribute(name="coinhboxallmc")
        private Sum coinBoxAllMoneyCollectionSum = new Sum(0);
        @XmlAttribute(name="zcashcount")
        private int zcashcount = 0;
        @XmlAttribute(name="zcashsum")
        private Sum zcashsum = new Sum(0);
        @XmlAttribute(name="zcashlesscount")
        private int zcashlesscount = 0;
        @XmlAttribute(name="zcashlesssum")
        private Sum zcashlesssum = new Sum(0);
        @XmlAttribute(name="zcoincount")
        private int zcoincount = 0;
        @XmlAttribute(name="zcoinsum")
        private Sum zcoinsum = new Sum(0);
        @XmlAttribute(name="zcoinunitcount")
        private int zcoinunitcount = 0;
        @XmlAttribute(name="znoteunitcount")
        private int znoteunitcount = 0;

        public ServiceZReportSnapshot() {
            this.cashBoxAllMoneyCollectionSum = new Sum(0);
            this.cashlessBoxAllMoneyCollectionSum = new Sum(0);
            this.coinBoxAllMoneyCollectionSum = new Sum(0);
            this.createdDate = new Date();
            this.zcashsum = new Sum(0);
            this.zcashcount = 0;
            this.zcashlesssum = new Sum(0);
            this.zcashlesscount = 0;
            this.zcoinsum = new Sum(0);
            this.zcoincount = 0;
            this.zcoinunitcount = 0;
            this.znoteunitcount = 0;
        }

        public ServiceZReportSnapshot(ServiceZReportSnapshot oldSnap) {
            this.cashBoxAllMoneyCollectionSum = new Sum(oldSnap.getCashBoxAllMoneyCollectionSum());
            this.cashlessBoxAllMoneyCollectionSum = new Sum(oldSnap.getCashlessBoxAllMoneyCollectionSum());
            this.coinBoxAllMoneyCollectionSum = new Sum(oldSnap.getCoinBoxAllMoneyCollectionSum());
            this.createdDate = new Date();
            this.zcashsum = new Sum(0);
            this.zcashcount = 0;
            this.zcashlesssum = new Sum(0);
            this.zcashlesscount = 0;
            this.zcoinsum = new Sum(0);
            this.zcoincount = 0;
            this.zcoinunitcount = 0;
            this.znoteunitcount = 0;
        }

        public Keeper getCashKeeper() {
            return this.cashKeeper;
        }

        public Keeper getCoinKeeper() {
            return this.coinKeeper;
        }

        public Sum getAllCurrentSum() {
            return this.zcashsum.add(this.zcashlesssum).add(this.zcoinsum);
        }

        public int getAllCurrentCount() {
            return this.zcoincount + this.zcashlesscount + this.zcashcount;
        }

        public Sum getCashBoxAllMoneyCollectionSum() {
            if (this.cashBoxAllMoneyCollectionSum == null) {
                this.cashBoxAllMoneyCollectionSum = new Sum(0);
            }
            return this.cashBoxAllMoneyCollectionSum;
        }

        public Sum getCashlessBoxAllMoneyCollectionSum() {
            if (this.cashlessBoxAllMoneyCollectionSum == null) {
                this.cashlessBoxAllMoneyCollectionSum = new Sum(0);
            }
            return this.cashlessBoxAllMoneyCollectionSum;
        }

        public Sum getCoinBoxAllMoneyCollectionSum() {
            if (this.coinBoxAllMoneyCollectionSum == null) {
                this.coinBoxAllMoneyCollectionSum = new Sum(0);
            }
            return this.coinBoxAllMoneyCollectionSum;
        }

        public Date getCreatedDate() {
            return this.createdDate;
        }

        public void setCreatedDate(Date createdDate) {
            this.createdDate = createdDate;
        }

        public void setCurrentMCSum(Keeper cashBoxKeeper, Keeper coinBoxKeeper) {
            this.cashKeeper = cashBoxKeeper;
            this.coinKeeper = coinBoxKeeper;
        }

        public void saveAll() {
            try {
                this.cashlessBoxAllMoneyCollectionSum = this.getCashlessBoxAllMoneyCollectionSum().add(this.zcashlesssum);
                this.cashBoxAllMoneyCollectionSum = this.getCashBoxAllMoneyCollectionSum().add(this.zcashsum);
                this.coinBoxAllMoneyCollectionSum = this.getCoinBoxAllMoneyCollectionSum().add(this.zcoinsum);
                ServiceZReportStorage.this.flushZReport();
            }
            catch (Exception ex) {
                log.error((Object)ex, (Throwable)ex);
            }
        }

        public void addZCashSum(Keeper addedKeeper) {
            if (addedKeeper != null && addedKeeper.getCashUnits() != null) {
                boolean noteUsed = false;
                boolean coinUsed = false;
                for (CashUnit cu : addedKeeper.getCashUnits().keySet()) {
                    int count = addedKeeper.getCashUnits().get(cu);
                    Sum addedSum = new Sum(cu.getNominal().getSum() * (double)count);
                    if (cu.getType() == 3) {
                        this.znoteunitcount += count;
                        noteUsed = true;
                        this.zcashsum = this.zcashsum.add(addedSum);
                        continue;
                    }
                    if (cu.getType() != 4) continue;
                    this.zcoinunitcount += count;
                    this.zcoinsum = this.zcoinsum.add(addedSum);
                    coinUsed = true;
                }
                if (noteUsed) {
                    ++this.zcashcount;
                } else if (coinUsed) {
                    ++this.zcoincount;
                }
                ServiceZReportStorage.this.flushZReport();
            }
        }

        public void mulZCashSum(Keeper muledKeeper) {
            if (muledKeeper != null && muledKeeper.getCashUnits() != null) {
                for (CashUnit cu : muledKeeper.getCashUnits().keySet()) {
                    int count = muledKeeper.getCashUnits().get(cu);
                    Sum muledSum = new Sum(cu.getNominal().getSum() * (double)count);
                    if (cu.getType() == 3) {
                        this.znoteunitcount -= muledKeeper.getCashUnits().get(cu).intValue();
                        this.zcashsum = this.zcashsum.mul(muledSum);
                        continue;
                    }
                    if (cu.getType() != 4) continue;
                    this.zcoinunitcount -= muledKeeper.getCashUnits().get(cu).intValue();
                    this.zcoinsum = this.zcoinsum.mul(muledSum);
                }
                ServiceZReportStorage.this.flushZReport();
            }
        }

        public void addZCashlessSum(Sum addedSum) {
            if (addedSum != null && addedSum.getSum() > 0.0) {
                ++this.zcashlesscount;
                this.zcashlesssum = this.zcashlesssum.add(addedSum);
                ServiceZReportStorage.this.flushZReport();
            }
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            try {
                resultMap.put("createdDate", this.createdDate);
                resultMap.put("cashlessboxAllMCS", this.getCashlessBoxAllMoneyCollectionSum());
                resultMap.put("cashboxAllMCS", this.getCashBoxAllMoneyCollectionSum());
                resultMap.put("coinboxAllMCS", this.getCoinBoxAllMoneyCollectionSum());
                resultMap.put("cashcoinboxAllMCS", this.getCashBoxAllMoneyCollectionSum().add(this.getCoinBoxAllMoneyCollectionSum()));
                resultMap.put("commonboxAllMCS", this.getCashBoxAllMoneyCollectionSum().add(this.getCoinBoxAllMoneyCollectionSum()).add(this.getCashlessBoxAllMoneyCollectionSum()));
                resultMap.put("cashboxkeeper", this.cashKeeper);
                resultMap.put("coinboxkeeper", this.coinKeeper);
                resultMap.put("cashcount", this.zcashcount);
                resultMap.put("cashboxCurrentMCS", this.zcashsum);
                resultMap.put("cashlesscount", this.zcashlesscount);
                resultMap.put("cashlessboxCurrentMCS", this.zcashlesssum);
                resultMap.put("coincount", this.zcoincount);
                resultMap.put("coinboxCurrentMCS", this.zcoinsum);
                resultMap.put("operationcount", this.zcoincount + this.zcashlesscount + this.zcashcount);
                resultMap.put("commonboxCurrentMCS", this.zcashsum.add(this.zcashlesssum).add(this.zcoinsum));
                resultMap.put("coinunitcount", this.zcoinunitcount);
                resultMap.put("noteunitcount", this.znoteunitcount);
                resultMap.put("cashunitcount", this.znoteunitcount + this.zcoinunitcount);
                resultMap.put("coinboxAllMCS", this.coinBoxAllMoneyCollectionSum);
            }
            catch (Exception ex) {
                log.error((Object)ex, (Throwable)ex);
                return resultMap;
            }
            return resultMap;
        }
    }
}

