/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app;

public abstract class ProblemNotifier {
    private static ProblemNotifier defaultNotifier;

    public static ProblemNotifier getDefaultNotifier() {
        return defaultNotifier;
    }

    public static void setDefaultNotifier(ProblemNotifier defaultNotifier) {
        ProblemNotifier.defaultNotifier = defaultNotifier;
    }

    public abstract void onError(Exception var1);

    public abstract void onProblem(String var1);

    public abstract void onProblemOnce(String var1);

    public abstract void onRequestRestart(String var1);

    public static void notifyError(Exception ex) {
        if (defaultNotifier != null) {
            defaultNotifier.onError(ex);
        }
    }

    public static void notifyProblem(String message) {
        if (defaultNotifier != null) {
            defaultNotifier.onProblem(message);
        }
    }

    public static void notifyProblemOnce(String message) {
        if (defaultNotifier != null) {
            defaultNotifier.onProblemOnce(message);
        }
    }

    public static void requestRestart(String cause) {
        if (defaultNotifier != null) {
            defaultNotifier.onRequestRestart(cause);
        }
    }
}

