/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app;

import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.CommissionStep;
import ru.softlogic.service.comission.SumResult;

public class MathCommissionCalculator {
    public static Sum calculateMin(Sum provTrade, double rate, double nds, Commission commission) {
        double result;
        Sum res;
        double comm = commission.getPercentValue();
        if (commission.getSteps() != null && commission.getSteps().size() > 0) {
            for (CommissionStep step : commission.getSteps().descendingSet()) {
                if (step.getSum().compareTo(provTrade) > 0) continue;
                comm = step.getPercentValue();
                break;
            }
        }
        if ((res = new Sum(result = (rate + rate * comm / 100.0) * provTrade.getSum() / (1.0 - nds / (1.0 + nds)))).getBasicSum() % 100 != 0) {
            res = new Sum(res.getBasicSum() / 100 * 100);
            res = res.add(new Sum(100));
        }
        return res;
    }

    public static Sum calculateMinNonNominal(Sum min, double rate, double nds, Commission commission) {
        double comm = commission.getPercentValue();
        double result = (rate + rate * comm / 100.0) * min.getSum() / (1.0 - nds / (1.0 + nds));
        Sum res = new Sum(result);
        if (res.getBasicSum() % 100 != 0) {
            res = new Sum(res.getBasicSum() / 100 * 100);
            res = res.add(new Sum(100));
        }
        return res;
    }

    public static Sum calculateProv(Sum sysTrade, double rate, double nds, Commission commission) {
        double comm = commission.getPercentValue();
        if (commission.getSteps() != null && commission.getSteps().size() > 0) {
            for (CommissionStep step : commission.getSteps().descendingSet()) {
                if (step.getSum().compareTo(sysTrade) > 0) continue;
                comm = step.getPercentValue();
                break;
            }
        }
        double in = sysTrade.getSum();
        double result = (in - in * (1.0 - 1.0 / (1.0 + nds))) / (rate + rate * comm / 100.0);
        result = (double)((int)(result * 100.0)) / 100.0;
        Sum res = new Sum(result);
        return res;
    }

    public static SumResult calculate(Sum in, Keeper keeper, Commission commission, Sum provTrade, double rate, double nds) {
        if (provTrade != null) {
            Sum res = MathCommissionCalculator.calculateMin(provTrade, rate, nds, commission);
            if (in.compareTo(res) >= 0) {
                double sysTrade = provTrade.getSum() * rate;
                sysTrade += sysTrade * nds;
                Sum st = new Sum(sysTrade);
                return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), st, provTrade, res.sub(st), in.sub(res), null, null);
            }
            return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), new Sum(0), new Sum(0), new Sum(0), in, null, null);
        }
        provTrade = MathCommissionCalculator.calculateProv(in, rate, nds, commission);
        double sysTrade = provTrade.getSum() * rate;
        sysTrade += sysTrade * nds;
        Sum st = new Sum(sysTrade);
        return new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), st, provTrade, in.sub(st), new Sum(0), null, null);
    }
}

