/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import ru.softlogic.app.AppEnvironmentListener;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.adv.AdvStatisticType;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.ServiceType;

public class AppEnvironment {
    private static final AppEnvironment instance = new AppEnvironment();
    private final Set<AppEnvironmentListener> listeners = new HashSet<AppEnvironmentListener>();

    private AppEnvironment() {
    }

    public static AppEnvironment getInstance() {
        return instance;
    }

    public void addListener(AppEnvironmentListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void open(ProviderType type) {
        for (AppEnvironmentListener ael : this.listeners) {
            ael.open(type);
        }
    }

    public void open(ProviderType type, Map<String, Object> data) {
        for (AppEnvironmentListener ael : this.listeners) {
            ael.open(type, data);
        }
    }

    public void open(MenuItem menuItem) {
        for (AppEnvironmentListener ael : this.listeners) {
            ael.open(menuItem);
        }
    }

    public void open(MenuItem menuItem, Map<String, Object> data) {
        for (AppEnvironmentListener ael : this.listeners) {
            ael.open(menuItem, data);
        }
    }

    public void open(Integer label) {
        for (AppEnvironmentListener ael : this.listeners) {
            ael.open(label);
        }
    }

    public void open(ServiceType serviceType) {
        for (AppEnvironmentListener ael : this.listeners) {
            ael.open(serviceType);
        }
    }

    public void setLocale(Locale locale) {
        for (AppEnvironmentListener ael : this.listeners) {
            ael.setLocale(locale);
        }
    }

    public void showInfo() {
        for (AppEnvironmentListener ael : this.listeners) {
            ael.showInfo();
        }
    }

    public void addAdvEvent(int id, AdvStatisticType type) {
        for (AppEnvironmentListener ael : this.listeners) {
            ael.addAdvEvent(id, type);
        }
    }

    public void addAdvEvent(List<Integer> bi, AdvStatisticType type) {
        for (AppEnvironmentListener ael : this.listeners) {
            ael.addAdvEvent(bi, type);
        }
    }

    public void onUserAction(String COMPLAINT) {
        for (AppEnvironmentListener ael : this.listeners) {
            ael.onUserAction(COMPLAINT);
        }
    }
}

