/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keyclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import ru.softlogic.keyclient.GenerateException;

public class X509Generator {
    public static X509RequestPair generateRequest(String subjectDN) throws GeneralSecurityException, IOException {
        SecureRandom sr = new SecureRandom();
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(1024, sr);
        KeyPair keypair = keyGen.generateKeyPair();
        PrivateKey privKey = keypair.getPrivate();
        PublicKey pubKey = keypair.getPublic();
        X500Principal subject = new X500Principal(subjectDN);
        PKCS10CertificationRequest request = new PKCS10CertificationRequest("SHA1withRSA", subject, pubKey, null, privKey);
        StringWriter sw = new StringWriter();
        PEMWriter writer = new PEMWriter((Writer)sw);
        writer.writeObject((Object)request);
        writer.close();
        String requestText = sw.toString();
        sw = new StringWriter();
        writer = new PEMWriter((Writer)sw);
        writer.writeObject((Object)privKey);
        writer.close();
        String keyText = sw.toString();
        return new X509RequestPair(keyText, requestText);
    }

    public static byte[] generatePKCS12(String privKey, String certificate, String password) throws GeneralSecurityException, IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PEMReader reader = new PEMReader((Reader)new StringReader(privKey));
        KeyPair kp = (KeyPair)reader.readObject();
        PrivateKey pk = kp.getPrivate();
        reader = new PEMReader((Reader)new StringReader(certificate));
        X509Certificate cert = (X509Certificate)reader.readObject();
        KeyStore store = KeyStore.getInstance("PKCS12");
        store.load(null, null);
        Certificate[] chain = new X509Certificate[]{cert};
        store.setKeyEntry("Client key", pk, password.toCharArray(), chain);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        store.store(baos, password.toCharArray());
        return baos.toByteArray();
    }

    public static EncodedKeyPair generatePrivateKey() throws GenerateException {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(1024, new SecureRandom());
            KeyPair pair = generator.genKeyPair();
            String privateKey = new String(Base64.encodeBase64((byte[])pair.getPrivate().getEncoded(), (boolean)true), "utf-8");
            String publicKey = new String(Base64.encodeBase64((byte[])pair.getPublic().getEncoded(), (boolean)true), "utf-8");
            return new EncodedKeyPair(privateKey, publicKey);
        }
        catch (Exception ex) {
            throw new GenerateException(ex);
        }
    }

    public static class EncodedKeyPair {
        private String privateKey;
        private String publicKey;

        public EncodedKeyPair(String privateKey, String publicKey) {
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }
    }

    public static class X509RequestPair {
        private String privKey;
        private String request;

        public X509RequestPair(String privKey, String request) {
            this.privKey = privKey;
            this.request = request;
        }

        public String getPrivKey() {
            return this.privKey;
        }

        public String getRequest() {
            return this.request;
        }
    }
}

