/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.text;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import ru.softlogic.input.model.field.text.Modificator;
import ru.softlogic.input.model.field.text.RegexModificatorRule;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RegexModificator
implements Modificator {
    public static final long serialVersionUID = 0L;
    @JsonProperty(value="rules")
    private final List<RegexModificatorRule> rules;

    @JsonCreator
    public RegexModificator(@JsonProperty(value="rules") List<RegexModificatorRule> rules) {
        this.rules = rules;
    }

    public List<RegexModificatorRule> getRules() {
        return this.rules;
    }

    @Override
    public String modify(String data) {
        if (data == null || this.rules == null) {
            return data;
        }
        for (RegexModificatorRule rr : this.rules) {
            if (!data.matches(rr.getRegex())) continue;
            return data.replaceAll(rr.getTarget(), rr.getValue());
        }
        return data;
    }

    public String toString() {
        return "RegexModificator{rules=" + this.rules + '}';
    }
}

