/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.text;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedList;
import java.util.List;
import ru.softlogic.input.model.field.numeric.Range;
import ru.softlogic.input.model.field.text.Validator;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class NumericRangeValidator
implements Validator {
    private static final long serialVersionUID = 1L;
    private final List<Range> ranges;

    public NumericRangeValidator(Range range) {
        this.ranges = new LinkedList<Range>();
        this.ranges.add(range);
    }

    @JsonCreator
    public NumericRangeValidator(@JsonProperty(value="ranges") List<Range> ranges) {
        this.ranges = ranges;
    }

    @Override
    public boolean validate(String data) {
        if (data == null || data.length() == 0) {
            return false;
        }
        if (!this.ranges.isEmpty()) {
            try {
                float val = Float.parseFloat(data.replace(",", "."));
                for (Range r : this.ranges) {
                    if (!(val >= r.getBegin()) || !(val <= r.getEnd())) continue;
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public String toString() {
        return "NumericRangeValidator{ranges=" + this.ranges + '}';
    }
}

