/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import ru.softlogic.input.model.ModelEnvironment;
import ru.softlogic.input.model.field.Field;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.keeper.annotation.documentation.TypeDoc;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@TypeDoc(value="\u041f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043b\u0435\u0439 \u0432\u0432\u043e\u0434\u0430")
public class FieldSequence
implements Serializable {
    public static final long serialVersionUID = 0L;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<IdentityField> fields;

    public FieldSequence() {
    }

    public FieldSequence(List<IdentityField> fields) {
        this.fields = fields;
    }

    public List<IdentityField> getFields() {
        return this.fields;
    }

    @JsonIgnore
    public List<FieldSequence> getFieldsByRows() {
        ArrayList<FieldSequence> result = new ArrayList<FieldSequence>();
        String prevRowId = null;
        FieldSequence currFields = null;
        for (int j = 0; j < this.fields.size(); ++j) {
            IdentityField field = this.fields.get(j);
            if (field == null) continue;
            if (field.getRowId() == null) {
                if (prevRowId != null) {
                    result.add(currFields);
                }
                currFields = new FieldSequence();
                currFields.addField(field);
                result.add(currFields);
            } else if (prevRowId == null) {
                currFields = new FieldSequence();
                currFields.addField(field);
            } else if (prevRowId.equals(field.getRowId())) {
                currFields.addField(field);
                if (j == this.fields.size() - 1) {
                    result.add(currFields);
                }
            } else {
                result.add(currFields);
                currFields = new FieldSequence();
                currFields.addField(field);
            }
            prevRowId = field.getRowId();
        }
        return result;
    }

    @JsonIgnore
    public String getRowId() {
        if (this.fields == null || this.fields.size() == 1) {
            return null;
        }
        IdentityField firstField = this.fields.get(0);
        if (firstField == null) {
            return null;
        }
        return firstField.getRowId();
    }

    public List<IdentityField> initFields(ModelEnvironment environment) throws InitException {
        if (this.fields != null) {
            for (Field field : this.fields) {
                if (field == null) continue;
                field.init(environment);
            }
        }
        return this.fields;
    }

    public void setFields(List<IdentityField> fields) {
        this.fields = fields;
    }

    private void addField(IdentityField field) {
        if (this.fields == null) {
            this.fields = new ArrayList<IdentityField>();
        }
        this.fields.add(field);
    }

    public String toString() {
        return "FieldSequence[fields=" + this.fields + ']';
    }
}

