/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import ru.softlogic.input.model.InputElementConsts;
import ru.softlogic.input.model.ModelEnvironment;
import ru.softlogic.input.model.field.FieldType;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.Placeholder;
import ru.softlogic.input.model.field.autocomplete.AutoCompleteField;
import ru.softlogic.input.model.field.checkbox.CheckBoxField;
import ru.softlogic.input.model.field.date.DateField;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.dependent.DependentSelectorField;
import ru.softlogic.input.model.field.table.TableField;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.keeper.annotation.documentation.FieldDoc;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@cls")
@JsonSubTypes(value={@JsonSubTypes.Type(value=TextField.class, name="f-text"), @JsonSubTypes.Type(value=NumericField.class, name="f-numeric"), @JsonSubTypes.Type(value=SelectorField.class, name="f-selector"), @JsonSubTypes.Type(value=DateField.class, name="f-date"), @JsonSubTypes.Type(value=CheckBoxField.class, name="f-checkbox"), @JsonSubTypes.Type(value=DependentSelectorField.class, name="f-dependent-selector"), @JsonSubTypes.Type(value=AutoCompleteField.class, name="f-autocomplete"), @JsonSubTypes.Type(value=TableField.class, name="f-tablefield"), @JsonSubTypes.Type(value=Placeholder.class, name="f-placeholder")})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class Field
extends InputElementConsts
implements Serializable {
    public static final long serialVersionUID = 0L;
    protected String id;
    @FieldDoc(value="\u0424\u043b\u0430\u0433\u0438 \u043f\u043e\u043b\u044f \u0432\u0432\u043e\u0434\u0430")
    protected int flags;
    private FieldType type;
    private boolean exist;
    @FieldDoc(value="\u0424\u043b\u0430\u0433 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043f\u043e\u043b\u044f")
    protected boolean required = true;
    @FieldDoc(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0431\u0443\u0434\u0435\u0442 \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u043e \u043f\u043e\u043b\u0435")
    protected String rowId;
    @FieldDoc(value="\u0428\u0438\u0440\u0438\u043d\u0430 \u043f\u043e\u043b\u044f \u0432\u0432\u043e\u0434\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u043c\u0435\u0449\u0435\u043d\u0438\u0438 \u0432 \u043e\u0434\u043d\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u0435")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    protected int width;
    @FieldDoc(value="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0438\u043a\u043e\u043d\u043a\u0438 \u0443 \u043f\u043e\u043b\u044f \u0432\u0432\u043e\u0434\u0430")
    private String icon;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FieldType getType() {
        return this.type;
    }

    protected final void setType(FieldType type) {
        this.type = type;
    }

    public boolean isExist() {
        return this.exist;
    }

    public void setExist(boolean exist) {
        this.exist = exist;
    }

    @JsonIgnore
    public boolean isInput() {
        return this.type.equals((Object)FieldType.Letter) || this.type.equals((Object)FieldType.Numeric);
    }

    @JsonIgnore
    public boolean isNumeric() {
        return this.type.equals((Object)FieldType.Numeric);
    }

    @JsonIgnore
    public boolean isSelector() {
        return this.type.equals((Object)FieldType.Selector);
    }

    @JsonIgnore
    public boolean isDate() {
        return this.type.equals((Object)FieldType.Date);
    }

    @JsonIgnore
    public boolean isSet() {
        return this.type.equals((Object)FieldType.Set);
    }

    @JsonIgnore
    public boolean isInfo() {
        return this.type.equals((Object)FieldType.Info);
    }

    @JsonIgnore
    public boolean isCheckBox() {
        return this.type.equals((Object)FieldType.CheckBox);
    }

    @JsonIgnore
    public boolean isPlaceholder() {
        return this.type.equals((Object)FieldType.Placeholder);
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean hasFlag(int flag) {
        return (this.flags & flag) > 0;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getRowId() {
        return this.rowId;
    }

    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public abstract void init(ModelEnvironment var1) throws InitException;

    public String toString() {
        return "Field [id='" + this.id + "'" + ", type=" + (Object)((Object)this.type) + ", exist=" + this.exist + ']';
    }
}

