/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.validator.sequence.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import ru.softlogic.input.model.advanced.actions.validator.sequence.util.Sequence;
import ru.softlogic.input.model.utils.FileUtil;

public class FileSequence
implements Sequence {
    private File sequenceFile;
    private long value;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public FileSequence(String sequencePath) throws Exception {
        this.sequenceFile = FileUtil.checkFile(sequencePath);
        this.value = 0L;
        DataInputStream input = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.sequenceFile);
            input = new DataInputStream(fis);
            this.value = input.readLong();
        }
        catch (IOException iOException) {
            FileUtil.close(input);
            FileUtil.close(fis);
            catch (Throwable throwable) {
                FileUtil.close(input);
                FileUtil.close(fis);
                throw throwable;
            }
        }
        FileUtil.close(input);
        FileUtil.close(fis);
    }

    @Override
    public synchronized long next() throws Exception {
        this.write(this.value + 1L);
        ++this.value;
        return this.value;
    }

    @Override
    public synchronized long getCurrent() {
        return this.value;
    }

    @Override
    public synchronized void setCurrent(long value) throws Exception {
        this.value = value;
        this.write(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(long value) throws Exception {
        FileOutputStream fis = null;
        DataOutputStream output = null;
        try {
            fis = new FileOutputStream(this.sequenceFile);
            output = new DataOutputStream(fis);
            output.writeLong(value);
        }
        catch (Throwable throwable) {
            FileUtil.close(fis);
            FileUtil.close(output);
            throw throwable;
        }
        FileUtil.close(fis);
        FileUtil.close(output);
    }
}

