/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.simple;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.advanced.actions.ExecuteException;
import ru.softlogic.input.model.advanced.configuration.RuntimeConfiguration;

public class XPath
implements ActionElement {
    private String fileName;
    private Map<String, List<InputElement>> single;
    private Map<String, InputElement> nodeset;

    public XPath(String fileName, Map<String, List<InputElement>> single, Map<String, InputElement> nodeset) {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("FileName is null");
        }
        if (single == null) {
            throw new IllegalArgumentException("Rules for single node is null");
        }
        if (nodeset == null) {
            throw new IllegalArgumentException("Rules for node set is null");
        }
        this.fileName = fileName;
        this.single = single;
        this.nodeset = nodeset;
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        String home = RuntimeConfiguration.getInstance().getHomePath();
        if (home == null) {
            throw new ExecuteException("RuntimeConfiguration is not inited, you must set-up data-source dir");
        }
        if (this.single.size() + this.nodeset.size() == 0) {
            throw new ExecuteException("There are no rules");
        }
        File source = new File(home, this.fileName);
        try {
            InputElement rie;
            XPathExpression expr;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(source);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            javax.xml.xpath.XPath xpath = xPathfactory.newXPath();
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry<String, List<InputElement>> entry : this.single.entrySet()) {
                expr = xpath.compile(this.processRequest(entry.getKey(), context));
                Node node = (Node)expr.evaluate(doc, XPathConstants.NODE);
                if (node == null) continue;
                for (InputElement template : entry.getValue()) {
                    rie = this.process(template, null, node);
                    result.put(rie.getKey(), rie);
                }
            }
            for (Map.Entry<String, Object> entry : this.nodeset.entrySet()) {
                expr = xpath.compile(this.processRequest(entry.getKey(), context));
                NodeList nl = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
                if (nl == null) continue;
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element el = (Element)nl.item(i);
                    rie = this.process((InputElement)entry.getValue(), i, el);
                    result.put(rie.getKey(), rie);
                }
            }
            context.putAll(result);
            context.execute();
        }
        catch (Exception e) {
            throw new ExecuteException("Error on xpath request, file=" + this.fileName, e);
        }
    }

    private String processRequest(String request, ActionContext context) throws ExecuteException {
        return ContextHelper.replaceParams(request, context);
    }

    private InputElement process(InputElement template, Integer index, Node node) {
        Map<String, String> attr = this.getAttributes(index, node);
        InputElement res = new InputElement();
        res.setFlags(template.getFlags());
        res.setKey(this.replace(template.getKey(), attr));
        res.setKeyTitle(this.replace(template.getKeyTitle(), attr));
        res.setKeyTitleId(this.replace(template.getKeyTitleId(), attr));
        res.setOriginalValue(this.replace(template.getOriginalValue(), attr));
        res.setValue(this.replace(template.getValue(), attr));
        res.setValueTitle(this.replace(template.getValueTitle(), attr));
        res.setValueTitleId(this.replace(template.getValueTitleId(), attr));
        return res;
    }

    private String replace(String value, Map<String, String> attr) {
        if (value == null || value.isEmpty() || !value.contains("@{") || !value.contains("}")) {
            return value;
        }
        for (Map.Entry<String, String> entry : attr.entrySet()) {
            if ((value = value.replace("@{" + entry.getKey() + "}", entry.getValue())).contains("@{")) continue;
            break;
        }
        return value;
    }

    private Map<String, String> getAttributes(Integer index, Node node) {
        HashMap<String, String> attr = new HashMap<String, String>();
        if (index != null) {
            attr.put("index", index.toString());
        }
        NamedNodeMap nnm = node.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node n = nnm.item(i);
            attr.put(n.getNodeName(), n.getNodeValue());
        }
        return attr;
    }

    public String toString() {
        return "XPath{fileName='" + this.fileName + '\'' + ", single=" + this.single + ", nodeset=" + this.nodeset + '}';
    }
}

