/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.script;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.advanced.actions.ExecuteException;
import ru.softlogic.input.model.advanced.actions.script.ExecuteScriptTask;

public class ExecuteScript
implements ActionElement {
    private static final long serialVersionUID = 1L;
    protected String fileName;
    protected List<String> paramsName;
    protected ActionMap actionMap;

    public ExecuteScript(String fileName, List<String> paramsName, ActionMap actionMap) {
        if (fileName == null) {
            throw new NullPointerException("File name is not set");
        }
        this.fileName = fileName;
        this.paramsName = paramsName;
        this.actionMap = actionMap;
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        List<String> rapams = this.buildParamsList(context, this.paramsName);
        ExecuteScriptTask requestTask = new ExecuteScriptTask(context, this.actionMap, this.fileName, rapams);
        context.getEnvironment().execute(requestTask);
    }

    private List<String> buildParamsList(ActionContext context, List<String> paramsName) throws ExecuteException {
        ArrayList<String> rapams;
        block4: {
            rapams = new ArrayList<String>();
            if (paramsName == null || paramsName.isEmpty()) break block4;
            if (paramsName.size() == 1 && "$all".equals(paramsName.get(0))) {
                for (Map.Entry<String, Object> entry : context.getData().entrySet()) {
                    if (!(entry.getValue() instanceof InputElement)) continue;
                    InputElement ie = (InputElement)entry.getValue();
                    rapams.add(ie.getValue());
                }
            } else {
                for (String param : paramsName) {
                    rapams.add(ContextHelper.getStringParam(param, context));
                }
            }
        }
        return rapams;
    }
}

