/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.NestedData;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.advanced.AsyncTask;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.advanced.actions.ExecuteException;
import ru.softlogic.input.model.advanced.actions.dialog.DialogAction;
import ru.softlogic.input.model.advanced.actions.dialog.DialogType;
import ru.softlogic.input.model.advanced.actions.request.ConnectorException;
import ru.softlogic.input.model.advanced.actions.request.RequestData;
import ru.softlogic.input.model.advanced.actions.request.Response;
import ru.softlogic.input.model.advanced.actions.simple.Cancel;
import ru.softlogic.input.model.advanced.messages.B;

public class DefaultOnlineRequest
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private final String function;
    private final List<String> params;
    private final ActionMap actionMap;
    private final Short idProvider;
    private final int attempts;
    private final int timeout;
    private final int timeoutAll;

    @JsonCreator
    public DefaultOnlineRequest(@JsonProperty(value="function") String function, @JsonProperty(value="params") List<String> params, @JsonProperty(value="actionMap") ActionMap actionMap, @JsonProperty(value="idProvider") Short idProvider, @JsonProperty(value="attempts") int attempts, @JsonProperty(value="timeout") int timeout, @JsonProperty(value="timeoutAll") int timeoutAll) {
        if (params == null || params.isEmpty()) {
            throw new IllegalArgumentException("Params must be set");
        }
        if (actionMap == null) {
            throw new IllegalArgumentException("ActionMap must be set");
        }
        if (attempts < 1 || attempts > 5) {
            throw new IllegalArgumentException("Attempts must be in range [0,5]");
        }
        if (timeout < 1 || timeout > 30) {
            throw new IllegalArgumentException("Timeout must be in range [1,30]");
        }
        if (timeoutAll < 30 || timeoutAll > 120) {
            throw new IllegalArgumentException("TimeoutAll must be in range [30,120]");
        }
        this.function = function;
        this.params = params;
        this.actionMap = actionMap;
        this.idProvider = idProvider;
        this.attempts = attempts;
        this.timeout = timeout;
        this.timeoutAll = timeoutAll;
    }

    public ActionMap getActionMap() {
        return this.actionMap;
    }

    public String getFunction() {
        return this.function;
    }

    public Short getIdProvider() {
        return this.idProvider;
    }

    public List<String> getParams() {
        return this.params;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getTimeoutAll() {
        return this.timeoutAll;
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        RequestData rd = new RequestData();
        rd.setIdService(context.getIdService());
        rd.setIdProvider(this.idProvider);
        rd.setFunction(this.function);
        HashMap<String, InputElement> map = new HashMap<String, InputElement>();
        HashMap<String, String> oldMap = new HashMap<String, String>();
        if (this.params != null) {
            if (this.params.size() == 1 && "$all".equals(this.params.get(0))) {
                Map<String, Object> data = context.getData();
                for (Object value : data.values()) {
                    if (!(value instanceof InputElement)) continue;
                    InputElement ie = (InputElement)value;
                    map.put(ie.getKey(), ie);
                    oldMap.put(ie.getKey(), ie.getValue());
                }
            } else {
                for (String param : this.params) {
                    map.put(param, ContextHelper.getIEParam(param, context));
                    oldMap.put(param, ContextHelper.getStringParam(param, context));
                }
            }
        }
        rd.setParamsIe(map);
        rd.setParams(oldMap);
        context.getEnvironment().execute(new RequestTask(rd, context));
    }

    private String getContextName() {
        return "online:" + this.function + "(" + this.params + ")";
    }

    public String toString() {
        return "DefaultOnlineRequest{function='" + this.function + '\'' + ", params=" + this.params + ", actionMap=" + this.actionMap + ", idProvider=" + this.idProvider + ", attempts=" + this.attempts + ", timeout=" + this.timeout + ", timeoutAll=" + this.timeoutAll + '}';
    }

    private class RequestTask
    implements AsyncTask {
        private final RequestData requestData;
        private final ActionContext context;

        public RequestTask(RequestData requestData, ActionContext context) {
            this.requestData = requestData;
            this.context = context;
        }

        @Override
        public Object execute() {
            ConnectorException lastEx = null;
            try {
                long start = System.currentTimeMillis();
                for (int i = 0; i < DefaultOnlineRequest.this.attempts; ++i) {
                    try {
                        return this.context.getEnvironment().getConnector().request(this.requestData);
                    }
                    catch (ConnectorException ex) {
                        lastEx = ex;
                        if (i < DefaultOnlineRequest.this.attempts - 1) {
                            Thread.sleep((long)DefaultOnlineRequest.this.timeout * 1000L);
                        }
                        if (System.currentTimeMillis() - start <= (long)DefaultOnlineRequest.this.timeoutAll * 1000L) {
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (InterruptedException ex1) {
                Thread.currentThread().interrupt();
            }
            return lastEx;
        }

        @Override
        public void onResult(Object result) {
            if (result instanceof Exception) {
                Exception ex = (Exception)result;
                Action action = DefaultOnlineRequest.this.actionMap.getActionByType("exception");
                if (action != null) {
                    ActionContext local = new ActionContext(DefaultOnlineRequest.this.getContextName(), this.context, action.getSequence());
                    local.setTransparent(true);
                    local.execute();
                } else {
                    this.context.getEnvironment().showError(new Exception("Error function call " + DefaultOnlineRequest.this.function + "(" + DefaultOnlineRequest.this.params + ")", ex));
                    this.context.cancelScript();
                }
            } else {
                Response resp = (Response)result;
                if (resp.getServerError() == 0 && resp.getServiceError() == 0) {
                    Action action = DefaultOnlineRequest.this.actionMap.getActionByType("success");
                    if (action != null) {
                        ActionContext local = new ActionContext(DefaultOnlineRequest.this.getContextName(), this.context, action.getSequence());
                        if (resp.getData() != null) {
                            Data data = (Data)resp.getData();
                            if (data.getElements() != null) {
                                for (InputElement el : ((Data)resp.getData()).getElements()) {
                                    Object object = local.get(el.getKey());
                                    if (object instanceof InputElement) {
                                        el.setKeyTitle(((InputElement)object).getKeyTitle());
                                    }
                                    local.put(el.getKey(), el);
                                }
                            }
                            if (data.getSum() != null) {
                                local.put("#sum", data.getSum());
                            }
                            if (data.getNestedData() != null) {
                                local.put(data.getNestedData().getId(), data.getNestedData().getData());
                            }
                            if (data.getFeeSum() != null) {
                                local.put("#fee-sum", data.getFeeSum());
                            }
                        }
                        local.execute();
                    } else {
                        this.context.execute();
                    }
                } else {
                    Action action = DefaultOnlineRequest.this.actionMap.getActionByType("error");
                    if (action != null) {
                        ActionContext local = new ActionContext(DefaultOnlineRequest.this.getContextName(), this.context, action.getSequence());
                        local.put("server_error", new InputElement("server_error", "Server error", "" + resp.getServerError()));
                        local.put("service_error", new InputElement("service_error", "Service error", "" + resp.getServiceError()));
                        Data data = (Data)resp.getData();
                        if (data != null) {
                            NestedData nestedData;
                            TransactionSum sum;
                            List<InputElement> elements = data.getElements();
                            if (elements != null) {
                                for (InputElement el : elements) {
                                    local.put(el.getKey(), el);
                                }
                            }
                            if ((sum = data.getSum()) != null) {
                                local.put("#sum", sum);
                            }
                            if ((nestedData = data.getNestedData()) != null) {
                                local.put(nestedData.getId(), nestedData.getData());
                            }
                        }
                        local.setTransparent(true);
                        local.execute();
                    } else {
                        LinkedList<ActionElement> actionElements = new LinkedList<ActionElement>();
                        DialogAction dialog = this.createDialog(resp);
                        actionElements.add(dialog);
                        ActionContext local = new ActionContext(DefaultOnlineRequest.this.getContextName(), this.context, actionElements);
                        local.execute();
                    }
                }
            }
        }

        private DialogAction createDialog(Response<Data> response) {
            int error;
            String prefix;
            if (response.getServerError() != 0) {
                prefix = "Request.server.";
                error = response.getServerError();
            } else {
                prefix = "Request.service.";
                error = response.getServiceError();
            }
            MessageFormat mf = new MessageFormat(B.get(prefix + "message"));
            DialogAction result = new DialogAction();
            result.setType(DialogType.Error);
            result.setTitle(B.get(prefix + "title"));
            if (error == 9) {
                String message = null;
                Data data = response.getData();
                if (data != null && data.getElements() != null) {
                    for (InputElement ie : data.getElements()) {
                        if (!"message".equals(ie.getKey())) continue;
                        message = ie.getValue();
                    }
                }
                if (message == null || message.isEmpty()) {
                    message = prefix + error;
                }
                result.setMessage(message);
            } else {
                result.setMessage(mf.format(new Object[]{B.get(prefix + error), error}));
            }
            result.setDefaultAction("ok");
            result.setTimeout(10);
            Action action = new Action("ok", "OK");
            action.setSequence(Collections.singletonList(new Cancel()));
            result.setActionMap(new ActionMap(action));
            return result;
        }

        public String toString() {
            return "RequestTask{requestData=" + this.requestData + '}';
        }
    }
}

