/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.hdw;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.AdvancedHardwareApi;
import ru.softlogic.input.model.advanced.AsyncTask;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.hdw.CardDispenserHandler;
import ru.softlogic.input.model.advanced.actions.hdw.HardwareAsyncTask;
import ru.softlogic.input.model.advanced.actions.hdw.HardwareException;
import ru.softlogic.input.model.advanced.actions.hdw.HardwareRequest;
import ru.softlogic.input.model.advanced.actions.request.Response;

public class CardDispenserRequest
extends HardwareRequest {
    public static final long serialVersionUID = 0L;
    public static final String FUNC_DISPENSE = "dispense";
    public static final String FUNC_READ_BC_DISPENSE = "bc-dispense";
    public static final String BARCODE_VALUE_KEY = "#cvd-barcode";

    public CardDispenserRequest(String function, List<String> params, ActionMap actionMap) {
        super(function, params, actionMap);
    }

    @Override
    protected AsyncTask _getAsyncTask(ActionContext context, Map<String, String> map) {
        return new RequestTask(context, this.function, map, this.actionMap);
    }

    private class RequestTask
    extends HardwareAsyncTask {
        private static final long serialVersionUID = 1L;

        public RequestTask(ActionContext context, String function, Map<String, String> params, ActionMap actionMap) {
            super(context, function, params, actionMap);
        }

        @Override
        public Response<Data> _execute(AdvancedHardwareApi hardwareApi) throws HardwareException {
            CardDispenserHandler cdh = hardwareApi.getCardDispenserHandler();
            if (cdh == null) {
                throw new HardwareException("Card dispenser handler is null");
            }
            ArrayList<InputElement> ieList = new ArrayList<InputElement>();
            if (CardDispenserRequest.FUNC_DISPENSE.equals(this.function)) {
                cdh.dispense();
                return new Response<Data>(0, 0, new Data(ieList));
            }
            if (CardDispenserRequest.FUNC_READ_BC_DISPENSE.equals(this.function)) {
                System.out.println("Params: " + this.params);
                String regex = ".+";
                if (this.params.size() == 1) {
                    regex = (String)this.params.values().iterator().next();
                } else if (this.params.size() > 1) {
                    throw new HardwareException("Too many params for this function");
                }
                String value = cdh.dispenseBarcode(regex);
                System.out.println("Barcode value");
                ieList.add(new InputElement(CardDispenserRequest.BARCODE_VALUE_KEY, CardDispenserRequest.BARCODE_VALUE_KEY, value));
                return new Response<Data>(0, 0, new Data(ieList));
            }
            throw new HardwareException("Unknown finction: " + this.function);
        }
    }
}

