/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.dialog;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.List;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.advanced.actions.ExecuteException;
import ru.softlogic.input.model.advanced.actions.dialog.DialogType;

public class DialogAction
implements ActionElement {
    public static final long serialVersionUID = 0L;
    @JsonIgnore
    private ActionContext ownContext;
    private DialogType type;
    private String title;
    private String titleId;
    private String message;
    private String messageId;
    private List<String> messParams;
    private int timeout;
    private String defaultAction;
    private ActionMap actionMap;

    public DialogAction() {
    }

    public DialogAction(DialogType type, String title, String message, int timeout, String defaultAction) {
        this.type = type;
        this.title = title;
        this.message = message;
        this.timeout = timeout;
        this.defaultAction = defaultAction;
        this.messParams = null;
    }

    public String getDefaultAction() {
        return this.defaultAction;
    }

    public void setDefaultAction(String defaultAction) {
        this.defaultAction = defaultAction;
    }

    public String getMessage() {
        Object[] objs = null;
        if (this.ownContext != null && this.messParams != null && !this.messParams.isEmpty()) {
            objs = new Object[this.messParams.size()];
            for (int i = 0; i < objs.length; ++i) {
                try {
                    objs[i] = ContextHelper.getStringParam(this.messParams.get(i), this.ownContext);
                    continue;
                }
                catch (Exception e) {
                    objs[i] = "";
                }
            }
        }
        MessageFormat mf = new MessageFormat(this.message);
        return mf.format(objs, new StringBuffer(), (FieldPosition)null).toString();
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DialogType getType() {
        return this.type;
    }

    public void setType(DialogType type) {
        this.type = type;
    }

    public ActionMap getActionMap() {
        return this.actionMap;
    }

    public void setActionMap(ActionMap actionMap) {
        this.actionMap = actionMap;
    }

    public ActionContext getOwnContext() {
        return this.ownContext;
    }

    public List<String> getMessParams() {
        return this.messParams;
    }

    public void setMessParams(List<String> messParams) {
        this.messParams = messParams;
    }

    public String getTitleId() {
        return this.titleId;
    }

    public void setTitleId(String titleId) {
        this.titleId = titleId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String toString() {
        return "DialogAction{type=" + (Object)((Object)this.type) + ", title=" + this.title + ", message=" + this.message + ", timeout=" + this.timeout + ", defaultAction=" + this.defaultAction + ", actionMap=" + this.actionMap + '}';
    }

    public void onSelectAction(String type) {
        Action action = this.actionMap.getActionByType(type);
        ActionContext local = new ActionContext("dialog_" + type, this.ownContext, action.getSequence());
        local.execute();
    }

    public void onCancel() {
        this.ownContext.cancelScript();
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        this.ownContext = context;
        context.getEnvironment().showDialog(this);
    }
}

