/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.conditional;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.LinkedList;
import java.util.List;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.advanced.actions.ExecuteException;
import ru.softlogic.input.model.advanced.actions.conditional.Case;
import ru.softlogic.input.model.advanced.expression.calculator.CalculateException;
import ru.softlogic.input.model.advanced.expression.calculator.ExpressionCalculator;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Switch
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private String expression;
    private String value;
    private List<Case> cases;
    private Case defaultCase;

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String condition) {
        this.value = condition;
    }

    public List<Case> getCases() {
        return this.cases;
    }

    public void setCases(List<Case> cases) {
        this.cases = cases;
    }

    public Case getDefaultCase() {
        return this.defaultCase;
    }

    public void setDefaultCase(Case defaultCase) {
        this.defaultCase = defaultCase;
    }

    public String toString() {
        return "Switch{expression=" + this.expression + ", condition=" + this.value + ", cases=" + this.cases + ", defaultCase=" + this.defaultCase + '}';
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        String contextName = "switch";
        String compValue = this.getCompValue(context);
        Case c = this.getCase(compValue, context);
        if (compValue != null) {
            contextName = contextName + "_" + this.value;
        } else if (c != null) {
            contextName = c.equals(this.defaultCase) ? contextName + "_default" : contextName + "_case_" + c.getExpression();
        }
        if (c == null) {
            c = new Case();
            c.setSequence(new LinkedList<ActionElement>());
        }
        new ActionContext(contextName, context, c.getSequence()).execute();
    }

    private String getCompValue(ActionContext context) throws ExecuteException {
        if (this.expression != null) {
            try {
                Object result = ExpressionCalculator.calculate(this.expression, context.getData());
                if (result instanceof Double) {
                    return this.format((Double)result);
                }
                if (result instanceof Integer) {
                    return this.format(((Integer)result).intValue());
                }
                return result.toString();
            }
            catch (CalculateException ex) {
                throw new ExecuteException(ex.getMessage(), ex);
            }
        }
        if (this.value != null) {
            return this.getArg(this.value, context);
        }
        return null;
    }

    private Case getCase(String compValue, ActionContext context) throws ExecuteException {
        if (compValue == null) {
            try {
                for (Case c : this.cases) {
                    Object result = ExpressionCalculator.calculate(c.getExpression(), context.getData());
                    if (result instanceof Boolean) {
                        if (!((Boolean)result).booleanValue()) continue;
                        return c;
                    }
                    throw new ExecuteException("Incorrect result type \"" + result.getClass().getName() + "\" in " + c);
                }
            }
            catch (CalculateException ex) {
                throw new ExecuteException(ex.getMessage(), ex);
            }
        } else {
            for (Case c : this.cases) {
                if (!compValue.equals(this.getArg(c.getValue(), context))) continue;
                return c;
            }
        }
        return this.defaultCase;
    }

    private String getArg(String id, ActionContext context) throws ExecuteException {
        try {
            float f = ContextHelper.getFloatParam(id, context);
            return this.format(f);
        }
        catch (ExecuteException ex) {
            return ContextHelper.getStringParam2(id, context);
        }
    }

    private String format(double d) {
        return Long.toString(Math.round(d * 100.0));
    }
}

