/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ru.softlogic.input.model.PrefillItem;
import ru.softlogic.input.model.RowParams;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.PaymentParams;
import ru.softlogic.input.model.advanced.SlaveScenarioException;
import ru.softlogic.input.model.advanced.SlaveScenarioParser;
import ru.softlogic.keeper.annotation.documentation.FieldDoc;
import ru.softlogic.keeper.annotation.documentation.TypeDoc;

@TypeDoc(value="\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439 \u043e\u043f\u043b\u0430\u0442\u044b")
public class Scenario
implements Serializable {
    @FieldDoc(value="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0432\u043e\u0433\u043e \u044d\u043a\u0440\u0430\u043d\u0430")
    private final String begin;
    @FieldDoc(value="")
    private final String beginProcess;
    @FieldDoc(value="")
    private final String beginEdit;
    private final String cardHandler;
    private final String changeNumber;
    @FieldDoc(key="\u041a\u043e\u0434 \u044d\u043a\u0440\u0430\u043d\u0430", value="\u042d\u043a\u0440\u0430\u043d\u044b \u043b\u043e\u0433\u0438\u043a\u0438 \u043e\u043f\u043b\u0430\u0442\u044b")
    private final Map<String, AdvancedScreenDescription> screens;
    @FieldDoc(value="\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043e\u043f\u043b\u0430\u0442\u044b")
    private final PaymentParams paymentParams;
    @FieldDoc(key="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", value="\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430")
    private final Map<String, PrefillItem> prefillItem;
    private final int features;
    private final int checkFeatures;
    private final SlaveScenarioParser screenParser;
    private volatile boolean loaded;
    @FieldDoc(value="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0432\u043e\u0433\u043e \u044d\u043a\u0440\u0430\u043d\u0430 \u0432 \u0441\u043b\u0443\u0447\u0430\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430")
    private String beginTemplate;
    @FieldDoc(value="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0432\u043e\u0433\u043e \u044d\u043a\u0440\u0430\u043d\u0430 \u0432 \u0441\u043b\u0443\u0447\u0430\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u0448\u0430\u0431\u043b\u043e\u043d\u0430")
    private String beginTemplateEdit;
    private Map<String, RowParams> rowParams;
    public static final long serialVersionUID = 0L;

    @JsonCreator
    public Scenario(@JsonProperty(value="begin") String begin, @JsonProperty(value="beginProcess") String beginProcess, @JsonProperty(value="beginEdit") String beginEdit, @JsonProperty(value="cardHandler") String cardHandler, @JsonProperty(value="changeNumber") String changeNumber, @JsonProperty(value="screens") Map<String, AdvancedScreenDescription> screens, @JsonProperty(value="paymentParams") PaymentParams paymentParams, @JsonProperty(value="prefillItem") Map<String, PrefillItem> prefillItem, @JsonProperty(value="features") int features, @JsonProperty(value="checkFeatures") int checkFeatures, @JsonProperty(value="screenParser") SlaveScenarioParser screenParser) {
        this.begin = begin;
        this.beginProcess = beginProcess;
        this.beginEdit = beginEdit;
        this.cardHandler = cardHandler;
        this.changeNumber = changeNumber;
        this.paymentParams = paymentParams;
        this.prefillItem = prefillItem;
        this.features = features;
        this.checkFeatures = checkFeatures;
        this.screenParser = screenParser;
        this.screens = screens != null ? screens : new HashMap<String, AdvancedScreenDescription>();
    }

    public Scenario(String begin, String beginProcess, String beginEdit, String cardHandler, String changeNumber, Map<String, AdvancedScreenDescription> screens, PaymentParams paymentParams, Map<String, PrefillItem> prefillItem, int features, int checkFeatures, SlaveScenarioParser screenParser, String beginTemplate) {
        this(begin, beginProcess, beginEdit, cardHandler, changeNumber, screens, paymentParams, prefillItem, features, checkFeatures, screenParser);
        this.beginTemplate = beginTemplate;
    }

    public Scenario(String begin, String beginProcess, String beginEdit, String cardHandler, String changeNumber, Map<String, AdvancedScreenDescription> screens, PaymentParams paymentParams, Map<String, PrefillItem> prefillItem, int features, int checkFeatures, SlaveScenarioParser screenParser, String beginTemplate, Map<String, RowParams> rowParams) {
        this(begin, beginProcess, beginEdit, cardHandler, changeNumber, screens, paymentParams, prefillItem, features, checkFeatures, screenParser, beginTemplate);
        this.rowParams = rowParams;
    }

    public Scenario(String begin, String beginProcess, String beginEdit, String cardHandler, String changeNumber, Map<String, AdvancedScreenDescription> screens, PaymentParams paymentParams, Map<String, PrefillItem> prefillItem, int features, int checkFeatures, SlaveScenarioParser screenParser, String beginTemplate, Map<String, RowParams> rowParams, String beginTemplateEdit) {
        this(begin, beginProcess, beginEdit, cardHandler, changeNumber, screens, paymentParams, prefillItem, features, checkFeatures, screenParser, beginTemplate, rowParams);
        this.beginTemplateEdit = beginTemplateEdit;
    }

    public void addScreen(AdvancedScreenDescription screen) {
        if (screen != null) {
            this.screens.put(screen.getDescription().getId(), screen);
        }
    }

    public synchronized AdvancedScreenDescription getScreenById(String id) {
        if (!this.loaded) {
            this.loadSlave();
        }
        return this.screens.get(id);
    }

    public String getBegin() {
        return this.begin;
    }

    public String getBeginEdit() {
        return this.beginEdit;
    }

    public String getBeginProcess() {
        return this.beginProcess;
    }

    public Map<String, AdvancedScreenDescription> getScreens() {
        return Collections.unmodifiableMap(this.screens);
    }

    public PaymentParams getPaymentParams() {
        return this.paymentParams;
    }

    public Map<String, PrefillItem> getPrefillItem() {
        return this.prefillItem;
    }

    public String getCardHandler() {
        return this.cardHandler;
    }

    public String getChangeNumber() {
        return this.changeNumber;
    }

    public int getFeatures() {
        return this.features;
    }

    public int getCheckFeatures() {
        return this.checkFeatures;
    }

    public String getBeginTemplate() {
        return this.beginTemplate;
    }

    public String getBeginTemplateEdit() {
        return this.beginTemplateEdit;
    }

    public void setBeginTemplateEdit(String beginTemplateEdit) {
        this.beginTemplateEdit = beginTemplateEdit;
    }

    public void setBeginTemplate(String beginTemplate) {
        this.beginTemplate = beginTemplate;
    }

    public synchronized void loadSlave() {
        try {
            Map<String, AdvancedScreenDescription> screensMap;
            if (this.screenParser != null && (screensMap = this.screenParser.parse()) != null) {
                this.screens.putAll(screensMap);
            }
        }
        catch (SlaveScenarioException slaveScenarioException) {
        }
        finally {
            this.loaded = true;
        }
    }

    public Map<String, RowParams> getRowParams() {
        return this.rowParams;
    }

    public void setRowParams(Map<String, RowParams> rowParams) {
        this.rowParams = rowParams;
    }

    public String toString() {
        return "Scenario{begin=" + this.begin + ", beginProcess=" + this.beginProcess + ", beginEdit=" + this.beginEdit + ", screens=" + this.screens + ", paymentParams=" + this.paymentParams + '}';
    }
}

