/*
 * Decompiled with CFR 0.152.
 */
package i18n;

import i18n.FileControl;
import i18n.NoMessageListener;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;

public class B {
    public static Locale logLocale = Locale.getDefault();
    public static File message;
    public static String parentBundle;
    private static NoMessageListener noMessageListener;

    public static void setParentBundle(String parentBundle) {
        B.parentBundle = parentBundle;
    }

    public static void setNoMessageListener(NoMessageListener noMessageListener) {
        B.noMessageListener = noMessageListener;
    }

    public static String get(String id) {
        if (parentBundle != null) {
            try {
                return ResourceBundle.getBundle(parentBundle).getString(id);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            return ResourceBundle.getBundle(".messages", new FileControl(message)).getString(id);
        }
        catch (Throwable th) {
            try {
                return ResourceBundle.getBundle("i18n.messages").getString(id);
            }
            catch (Throwable e) {
                if (noMessageListener != null) {
                    noMessageListener.noMessage("message, id=" + id);
                }
                return "message, id=" + id;
            }
        }
    }

    public static String get(String id, Locale locale) {
        if (parentBundle != null) {
            try {
                if (locale != null) {
                    return ResourceBundle.getBundle(parentBundle, locale, new FileControl(message)).getString(id);
                }
                return ResourceBundle.getBundle(parentBundle, new FileControl(message)).getString(id);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            if (locale != null) {
                return ResourceBundle.getBundle(".messages", locale, new FileControl(message)).getString(id);
            }
            return ResourceBundle.getBundle(".messages", new FileControl(message)).getString(id);
        }
        catch (Throwable th) {
            try {
                if (locale != null) {
                    return ResourceBundle.getBundle("i18n.messages", locale).getString(id);
                }
                return ResourceBundle.getBundle("i18n.messages").getString(id);
            }
            catch (Throwable e) {
                if (noMessageListener != null) {
                    noMessageListener.noMessage("message, id=" + id);
                }
                return "message, id=" + id;
            }
        }
    }

    public static String get(String id, Locale locale, String defaultValue) {
        if (parentBundle != null) {
            try {
                if (locale != null) {
                    return ResourceBundle.getBundle(parentBundle, locale, new FileControl(message)).getString(id);
                }
                return ResourceBundle.getBundle(parentBundle, new FileControl(message)).getString(id);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            if (locale != null) {
                return ResourceBundle.getBundle(".messages", locale, new FileControl(message)).getString(id);
            }
            return ResourceBundle.getBundle(".messages", new FileControl(message)).getString(id);
        }
        catch (Throwable th) {
            try {
                if (locale != null) {
                    return ResourceBundle.getBundle("i18n.messages", locale).getString(id);
                }
                return ResourceBundle.getBundle("i18n.messages").getString(id);
            }
            catch (Throwable e) {
                return defaultValue;
            }
        }
    }

    public static String log(String id) {
        try {
            return ResourceBundle.getBundle(".messages", logLocale, new FileControl(message)).getString(id);
        }
        catch (Throwable th) {
            try {
                return ResourceBundle.getBundle("i18n.messages", logLocale).getString(id);
            }
            catch (Throwable e) {
                if (noMessageListener != null) {
                    noMessageListener.noMessage("message, id=" + id);
                }
                return "message, id=" + id;
            }
        }
    }
}

