/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.utils;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import ru.softlogic.cash.Sum;
import ru.softlogic.system.util.MoneyToStr;

public class SumFormatter
implements Serializable {
    public static String format(int sum) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingUsed(false);
        return df.format((double)sum / 100.0);
    }

    public static String format(long sum) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingUsed(false);
        return df.format((double)sum / 100.0);
    }

    public static String format(double sum) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingUsed(false);
        return df.format(sum);
    }

    public static String formatComma(int sum) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setDecimalSeparator(',');
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingUsed(false);
        return df.format((double)sum / 100.0);
    }

    public static String formatComma(double sum) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setDecimalSeparator(',');
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingUsed(false);
        return df.format(sum);
    }

    public static String formatRound(int sum) {
        if (sum % 100 != 0) {
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            df.setDecimalFormatSymbols(dfs);
            df.setGroupingUsed(false);
            return df.format((double)sum / 100.0);
        }
        return "" + sum / 100;
    }

    public static String getMoney(double money) {
        return new MoneyToStr().getMoney(money);
    }

    public static String getMoney(int money) {
        return new MoneyToStr().format((double)money);
    }

    public static String getMoney(Sum sum) {
        return new MoneyToStr().format(sum.getSum());
    }
}

