/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.utils;

import java.util.List;
import java.util.Map;

public class ByteUtils {
    public byte[] pack(Map<Byte, byte[]> rules, byte[] data) {
        if (data == null || data.length == 0) {
            return data;
        }
        if (rules == null || rules.isEmpty()) {
            return data;
        }
        return null;
    }

    public static byte[] convert(List<Byte> list) {
        if (list == null) {
            return null;
        }
        byte[] res = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            res[i] = list.get(i);
        }
        return res;
    }

    public static String toString(byte[] data) {
        if (data == null) {
            return "";
        }
        String str = "";
        for (byte b : data) {
            str = str + String.format("%02X ", b);
        }
        return str;
    }

    public static String toString(List<Byte> data) {
        String str = "";
        for (byte b : data) {
            str = str + String.format("%02X ", b);
        }
        return str;
    }

    public static void add(List<Byte> data, byte[] newData) {
        if (data != null && newData != null) {
            for (byte b : newData) {
                data.add(b);
            }
        }
    }

    public static boolean isStringChar(char ch) {
        if (ch >= 'a' && ch <= 'z') {
            return true;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return true;
        }
        if (ch >= '0' && ch <= '9') {
            return true;
        }
        switch (ch) {
            case ' ': 
            case '$': 
            case '%': 
            case '\'': 
            case '(': 
            case ')': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '<': 
            case '>': 
            case '[': 
            case ']': 
            case '_': {
                return true;
            }
        }
        return false;
    }
}

