/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.utils;

public class BCDUtils {
    public static byte[] convert(int num, int width) {
        if (num < 0) {
            throw new IllegalArgumentException("num");
        }
        if (width < 0 || width > 10) {
            throw new IllegalArgumentException("width");
        }
        String data = String.format("%0" + width * 2 + "d", num);
        byte[] res = new byte[width];
        for (int i = 0; i < width; ++i) {
            res[i] = (byte)(Integer.parseInt(data.substring(i * 2, i * 2 + 2), 16) & 0xFF);
        }
        return res;
    }

    public static String bcdToAscii(byte ... data) {
        if (data == null || data.length == 0) {
            return "";
        }
        String res = "";
        for (byte b : data) {
            res = res + String.format("%02x", b);
        }
        return res;
    }
}

