/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.proto.payonline;

import java.io.IOException;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.proto.payonline.R;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;

public class Connection {
    private final byte ENQ = (byte)5;
    private final byte STX = (byte)2;
    private final byte ACK = (byte)6;
    private final byte NAK = (byte)21;
    private final SerialPort port;
    private final Logger log;
    private int attempts = 5;
    private int attemptsTimeout = 3000;

    public Connection(SerialPort port) {
        this.port = port;
        this.log = Logger.getLogger((String)"print");
    }

    public void setAttempts(int attempts) {
        if (attempts < 1 || attempts > 20) {
            throw new IllegalArgumentException("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u043f\u044b\u0442\u043e\u043a \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u043e\u043c\u0435\u0436\u0443\u0442\u043a\u0435 \u043e\u0442 1 \u0434\u043e 20");
        }
        this.attempts = attempts;
    }

    public void setAttemptsTimeout(int attemptsTimeout) {
        this.attemptsTimeout = attemptsTimeout;
    }

    public R sendCommand(int cmd, byte[] password, byte[] data) throws IOException {
        return this.sendCommand(cmd, password, data, 500, 1000);
    }

    public synchronized R sendCommand(int cmd, byte[] password, byte[] data, int enqTimeout, int answerTimeout) throws IOException {
        R last = null;
        for (int i = 0; i < 20; ++i) {
            R res = this._sendCommand(cmd, password, data, enqTimeout, answerTimeout);
            switch (res.getCode()) {
                case 80: {
                    this.log.info((Object)"\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430. \u041e\u0436\u0438\u0434\u0430\u044e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f...");
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    break;
                }
                case 88: {
                    this.log.info((Object)"\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u044f \u043f\u0435\u0447\u0430\u0442\u0438");
                    this._sendCommand(176, password, null, enqTimeout, answerTimeout);
                    break;
                }
                default: {
                    return res;
                }
            }
            last = res;
        }
        return last;
    }

    private R _sendCommand(int cmd, byte[] password, byte[] data, int enqTimeout, int answerTimeout) throws IOException {
        IOException last = null;
        byte[] message = this.formMessage(cmd, password, data);
        for (int i = 0; i < this.attempts; ++i) {
            try {
                this.port.flush(Flush.RxTx);
                this.port.setTimeout(enqTimeout);
                this.log.debug((Object)">> ENQ");
                this.port.write((byte)5);
                int res = this.port.readByte();
                switch (res) {
                    case 21: {
                        this.log.debug((Object)"<< NAK");
                        this.log.debug((Object)"\u0413\u043e\u0442\u043e\u0432 \u043a \u0440\u0430\u0431\u043e\u0442\u0435, \u0437\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u044e \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u0443");
                        this.log.debug((Object)(">> " + ByteUtils.toString(message)));
                        this.port.write(message);
                        this.log.debug((Object)"\u041a\u043e\u043c\u043c\u0430\u043d\u0434\u0430 \u0437\u0430\u043f\u0438\u0441\u0430\u043d\u0430, \u0447\u0438\u0442\u0430\u044e \u0431\u0430\u0439\u0442 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0435\u043d\u0438\u044f");
                        int ans = this.port.readByte();
                        this.log.debug((Object)("<< " + String.format("%02x", ans)));
                        if (ans != 6) {
                            throw new IOException("\u0424\u0420 \u043d\u0435 \u0441\u043c\u043e\u0433 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u043f\u0440\u0438\u043d\u044f\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443");
                        }
                        return this.readMessage(cmd, answerTimeout);
                    }
                    case 6: {
                        this.log.debug((Object)"<< ACK");
                        this.log.info((Object)"\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0443\u044e \u043a\u043e\u043c\u0430\u043d\u0434\u0443");
                        this.readMessage(null, answerTimeout);
                        break;
                    }
                    default: {
                        this.log.debug((Object)("<< " + String.format("0x%02X", res) + ", \u0432\u044b\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u043c \u043c\u0443\u0441\u043e\u0440"));
                        this.port.setTimeout(3);
                        this.log.debug((Object)("<< \u041c\u0443\u0441\u043e\u0440=" + ByteUtils.toString(this.port.tryRead())));
                        this.port.write((byte)6);
                        this.log.debug((Object)"<< ACK");
                        break;
                    }
                }
                continue;
            }
            catch (IOException ex) {
                last = ex;
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 \u0424\u0420, \u043f\u043e\u043f\u044b\u0442\u043a\u0430 " + (i + 1)), (Throwable)ex);
                if (i + 1 >= this.attempts) continue;
                try {
                    Random rnd = new Random();
                    this.log.info((Object)("Sleep timeout=" + this.attemptsTimeout));
                    int r = rnd.nextInt(this.attemptsTimeout);
                    this.log.info((Object)("Sleep " + r + " msec"));
                    Thread.sleep(r);
                    continue;
                }
                catch (InterruptedException ex1) {
                    Thread.currentThread().interrupt();
                    throw new IOException(ex1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        throw new IOException("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u0441\u043b\u0430\u0442\u044c \u043f\u0430\u043a\u0435\u0442 \u0437\u0430 " + this.attempts + " \u043f\u043e\u043f\u044b\u0442\u043e\u043a", last);
    }

    private R readMessage(Integer cmd, int timeout) throws IOException {
        this.log.debug((Object)"\u0427\u0438\u0442\u0430\u0435\u043c \u043e\u0442\u0432\u0435\u0442:");
        this.port.setTimeout(timeout);
        int cnt = 0;
        int start = this.port.readByte();
        while (start != 2) {
            this.log.debug((Object)("<< " + String.format("%02x", start)));
            if (++cnt != 150) continue;
            throw new IOException("too long");
        }
        this.log.debug((Object)"<< STX");
        int len = this.port.readByte();
        this.log.debug((Object)("<< LEN = " + len));
        byte[] answer = new byte[len + 3];
        answer[0] = 2;
        answer[1] = (byte)len;
        this.port.setTimeout(len * 25 + 500);
        byte[] oth = this.port.read(len + 1);
        this.log.debug((Object)("<< " + ByteUtils.toString(oth)));
        System.arraycopy(oth, 0, answer, 2, oth.length);
        this.port.setTimeout(200);
        if (answer.length < 4) {
            this.log.debug((Object)">> NAK");
            this.port.write((byte)21);
            throw new IOException("\u0414\u043b\u0438\u043d\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043d\u0435 \u043c\u0435\u043d\u0435\u0435 4-\u0445 \u0431\u0430\u0439\u0442");
        }
        if (answer[answer.length - 1] != this.getLrc(answer)) {
            this.log.debug((Object)">> NAK");
            this.port.write((byte)21);
            throw new IOException("\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043e\u0442\u0432\u0435\u0442\u0430");
        }
        int answercmd = 0;
        answercmd = (answer[2] & 0xFF) == 255 ? 65280 + answer[3] : answer[2] & 0xFF;
        if (cmd != null && answercmd != cmd) {
            this.log.debug((Object)">> NAK");
            this.port.write((byte)21);
            throw new IOException("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043e\u0442\u0432\u0435\u0442 \u043e\u0442 \u0434\u0440\u0443\u0433\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b. \u041e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c: " + cmd + ", \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e: " + answercmd);
        }
        this.log.debug((Object)">> ACK");
        this.port.write((byte)6);
        byte[] result = null;
        int expectedLength = 4;
        if ((answer[2] & 0xFF) == 255) {
            expectedLength = 5;
        }
        if (answer.length > expectedLength) {
            result = new byte[answer.length - expectedLength - 1];
            for (int i = 0; i < answer.length - expectedLength - 1; ++i) {
                result[i] = answer[i + expectedLength];
            }
        }
        return new R(answer[3 + expectedLength - 4], result);
    }

    private byte[] formMessage(int cmd, byte[] password, byte[] data) {
        if (password != null && password.length != 4) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u043e\u043b\u044c \u0424\u0420 \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u043e");
        }
        int minLen = (cmd >> 8 & 0xFF) == 0 ? 4 : 5;
        byte[] message = new byte[minLen + (password == null ? 0 : password.length) + (data == null ? 0 : data.length)];
        message[0] = 2;
        message[1] = (byte)(message.length - 3);
        message[2] = (byte)(cmd & 0xFF);
        int hcmd = cmd >> 8;
        int pos = 3;
        if (hcmd != 0) {
            message[2] = (byte)(hcmd & 0xFF);
            message[3] = (byte)(cmd & 0xFF);
            ++pos;
        }
        int i = 0;
        if (password != null) {
            for (i = 0; i < password.length; ++i) {
                message[pos + i] = password[i];
            }
        }
        if (data != null && data.length > 0) {
            System.arraycopy(data, 0, message, pos + i, data.length);
        }
        message[message.length - 1] = this.getLrc(message);
        this.logDataFlow(">>", message);
        return message;
    }

    private byte getLrc(byte[] data) {
        if (data == null || data.length < 2) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f LRC");
        }
        byte result = data[1];
        for (int i = 2; i < data.length - 1; ++i) {
            result = (byte)(result ^ data[i]);
        }
        return result;
    }

    private void logDataFlow(String name, byte[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        StringBuilder result = new StringBuilder();
        if (name != null && !name.isEmpty()) {
            result.append(name).append(": ");
        }
        for (int i = 0; i < data.length; ++i) {
            result.append(String.format("0x%02x ", data[i]));
        }
        this.log.debug((Object)result.toString());
    }
}

