/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.proto.payonline;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.proto.payonline.Connection;
import ru.softlogic.hardware.proto.payonline.FontData;
import ru.softlogic.hardware.proto.payonline.InfoExchangeStatus;
import ru.softlogic.hardware.proto.payonline.LongStatus;
import ru.softlogic.hardware.proto.payonline.R;
import ru.softlogic.hardware.proto.payonline.Result;
import ru.softlogic.hardware.proto.payonline.Status;
import ru.softlogic.hardware.proto.shtihm.Info;
import ru.softlogic.hardware.utils.StringUtils;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.utils.BU;
import ru.softlogic.srv.connector.ZReportInfo;
import ru.softlogic.system.util.ArrayUtils;

public class Api
implements SerialDeviceApi {
    private SerialPort serialPort;
    private Map<Boolean, SerialParams[]> serialParams;
    private Connection conn;
    private byte[] oPassword;
    private byte[] aPassword;
    private Logger log;
    private Boolean cutSupport;
    private List<Integer> cutUnsupportModels;
    private Integer printWidth;
    private Map<Integer, Integer> printWidthModels;

    public Api(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.serialPort = port;
        this.conn = new Connection(port);
        this.serialParams = new HashMap<Boolean, SerialParams[]>();
        this.serialParams.put(Boolean.TRUE, new SerialParams[]{new SerialParams(4800, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None)});
        this.serialParams.put(Boolean.FALSE, new SerialParams[]{new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(2400, DataBits.Eight, StopBits.One, Parity.None)});
        this.setAdministratorPassword(30);
        this.setOperatorPassword(30);
        this.cutUnsupportModels = new LinkedList<Integer>();
        this.cutUnsupportModels.add(6);
        this.printWidthModels = new HashMap<Integer, Integer>();
        this.printWidthModels.put(6, 32);
        this.printWidthModels.put(7, 40);
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
    }

    public final void setOperatorPassword(int password) {
        this.oPassword = this.getPassword(password);
    }

    public final void setAdministratorPassword(int password) {
        this.aPassword = this.getPassword(password);
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return (SerialParams[])ArrayUtils.arrayMerge((Object[][])new SerialParams[][]{this.serialParams.get(true), this.serialParams.get(false)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        this.conn.setAttempts(3);
        this.conn.setAttemptsTimeout(100);
        for (SerialParams params : this.serialParams.get(preferred)) {
            this.log.info((Object)("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b: " + params));
            try {
                this.serialPort.putParams(params);
                this.open();
                Result<Info> infoRes = this.getInfo();
                if (!infoRes.isOk()) {
                    DeviceType deviceType = null;
                    return deviceType;
                }
                Info info = infoRes.getData();
                switch (info.getModel()) {
                    case 243: 
                    case 248: 
                    case 249: {
                        DeviceType deviceType = DeviceType.YarusKkm;
                        return deviceType;
                    }
                    case 250: 
                    case 255: {
                        DeviceType deviceType = DeviceType.PayonlineKkm;
                        return deviceType;
                    }
                    case 4: {
                        DeviceType deviceType = DeviceType.ShtrihFrkKkm;
                        return deviceType;
                    }
                }
                DeviceType deviceType = DeviceType.ShtrihKkm;
                return deviceType;
            }
            catch (IOException iOException) {
            }
            finally {
                this.close();
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.serialPort.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    public int seTime(Date date) throws IOException {
        if (date == null) {
            throw new IllegalArgumentException("\u0414\u0430\u0442\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u043e");
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        return this.conn.sendCommand(33, this.aPassword, new byte[]{(byte)hour, (byte)minute, (byte)second}).getCode();
    }

    public int setDate(Date date) throws IOException {
        if (date == null) {
            throw new IllegalArgumentException("\u0414\u0430\u0442\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u043e");
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int day = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1) % 100;
        return this.conn.sendCommand(34, this.aPassword, new byte[]{(byte)day, (byte)(month + 1), (byte)year}).getCode();
    }

    public int dateCommit(Date date) throws IOException {
        if (date == null) {
            throw new IllegalArgumentException("\u0414\u0430\u0442\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u043e");
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int day = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1) % 100;
        return this.conn.sendCommand(35, this.aPassword, new byte[]{(byte)day, (byte)(month + 1), (byte)year}).getCode();
    }

    public int cashOut(int sum) throws IOException {
        byte[] data = new byte[]{(byte)(sum & 0xFF), (byte)(sum >> 8 & 0xFF), (byte)(sum >> 16 & 0xFF), (byte)(sum >> 24 & 0xFF), 0};
        return this.conn.sendCommand(81, this.aPassword, data).getCode();
    }

    public Result<Integer> getCashReg(int num) throws IOException {
        R res = this.conn.sendCommand(26, this.aPassword, new byte[]{(byte)num});
        Result yr = new Result(res.getCode());
        if (res.getCode() == 0) {
            byte[] b = res.getData();
            return new Result<Integer>(res.getCode(), (b[1] & 0xFF) + ((b[2] & 0xFF) << 8) + ((b[3] & 0xFF) << 16) + ((b[4] & 0xFF) << 24));
        }
        return new Result<Integer>(res.getCode());
    }

    public SerialPort getPort() {
        return this.serialPort;
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.PayonlineKkm;
    }

    @Override
    public void open() throws IOException {
        this.serialPort.open();
    }

    @Override
    public void close() {
        this.serialPort.close();
    }

    public Result<Info> getInfo() throws IOException {
        R res = this.conn.sendCommand(252, null, null);
        if (res.getCode() != 0) {
            return new Result<Info>(res.getCode());
        }
        byte[] data = res.getData();
        if (data == null || data.length < 8) {
            throw new IOException("\u041d\u0435\u0442 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430");
        }
        Info si = new Info();
        si.setType(data[0] & 0xFF);
        si.setSubtype(data[1] & 0xFF);
        si.setProto(data[2] & 0xFF);
        si.setSubproto(data[3] & 0xFF);
        si.setModel(data[4] & 0xFF);
        si.setLang(data[5] & 0xFF);
        this.log.info((Object)"\u0427\u0438\u0442\u0430\u044e \u0441\u0442\u0430\u0442\u0443\u0441 \u0424\u041d");
        this.conn.sendCommand(65281, this.aPassword, null);
        try {
            si.setName(new String(data, 6, data.length - 6, "cp1251"));
        }
        catch (UnsupportedEncodingException ex) {
            si.setName("n/a");
        }
        return new Result<Info>(res.getCode(), si);
    }

    public Result<Status> getShortStatus() throws IOException {
        R res = this.conn.sendCommand(16, this.oPassword, null);
        Status result = new Status();
        if (res.getCode() != 0) {
            return new Result<Status>(res.getCode());
        }
        if (res.getData() == null || res.getData().length < 14) {
            throw new IOException("\u0414\u0430\u043d\u043d\u044b\u0435 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u044b");
        }
        byte[] data = res.getData();
        result.setFlags((data[1] & 0xFF) + (data[2] << 8 & 0xFF00));
        result.setMode(data[3] & 0xFF);
        result.setSubMode(data[4] & 0xFF);
        result.setErrFp(data[8] & 0xFF);
        result.setErrEklz(data[9] & 0xFF);
        return new Result<Status>(res.getCode(), result);
    }

    public void readAllDocs() {
        this.log.info((Object)"\u0418\u0449\u0443 \u043d\u0435\u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b: ");
        try {
            R res;
            int i = 1;
            while ((res = this.conn.sendCommand(65290, this.aPassword, new byte[]{(byte)(i & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 24 & 0xFF)})).getCode() == 0) {
                String type = null;
                if (res.getData()[1] != 0) {
                    switch (res.getData()[0]) {
                        case 1: {
                            type = "\u041e\u0442\u0447\u0435\u0442 \u043e \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u043a\u043a\u0442";
                            break;
                        }
                        case 2: {
                            type = "\u041e\u0442\u0447\u0435\u0442 \u043e\u0431 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0438 \u0441\u043c\u0435\u043d\u044b";
                            break;
                        }
                        case 3: {
                            type = "\u041a\u0430\u0441\u0441\u043e\u0432\u044b\u0439 \u0447\u0435\u043a";
                            break;
                        }
                        case 5: {
                            type = "\u041e\u0442\u0447\u0435\u0442 \u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u0441\u043c\u0435\u043d\u044b";
                            break;
                        }
                        default: {
                            type = "";
                        }
                    }
                    this.log.info((Object)("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u2116" + i + "\u0435\u0449\u0435 \u043d\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d \u043d\u0430 \u043e\u0444\u0434, \u0442\u0438\u043f: " + res.getData()[0] + " " + type));
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Result<LongStatus> getLongStatus() throws IOException {
        R res = this.conn.sendCommand(17, this.oPassword, null);
        if (res.getCode() != 0) {
            return new Result<LongStatus>(res.getCode());
        }
        if (res.getData() == null || res.getData().length < 46) {
            throw new IOException("\u0414\u0430\u043d\u043d\u044b\u0435 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u044b");
        }
        byte[] data = res.getData();
        LongStatus result = new LongStatus();
        try {
            result.setSoftwareVersionFr(new String(data, 0, 1, "cp1251") + "." + new String(data, 1, 1, "cp1251"));
        }
        catch (UnsupportedEncodingException ex) {
            result.setSoftwareVersionFr("n/a");
        }
        result.setSoftwareBuildFr((data[2] & 0xFF) + ((data[3] & 0xFF) << 8));
        result.setSoftwareDateBuildFr(String.format("%02d", data[5] & 0xFF) + "." + String.format("%02d", data[6] & 0xFF) + "." + String.format("%02d", data[7] & 0xFF));
        result.setCheckNumber((data[11] & 0xFF) + ((data[12] & 0xFF) << 8));
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(1, data[25] + 2000);
            cal.set(2, data[24] - 1);
            cal.set(5, data[23]);
            cal.set(11, data[26]);
            cal.set(12, data[27]);
            cal.set(13, data[28]);
            result.setDate(cal.getTime());
        }
        catch (Throwable cal) {
            // empty catch block
        }
        result.setNumber((data[30] & 0xFF) + ((data[31] & 0xFF) << 8) + ((data[32] & 0xFF) << 16) + ((data[33] & 0xFF) << 24));
        Status ss = new Status();
        ss.setFlags((data[11] & 0xFF) + (data[12] << 8 & 0xFF00));
        ss.setMode(data[13] & 0xFF);
        ss.setSubMode(data[14] & 0xFF);
        result.setShortStatus(ss);
        return new Result<LongStatus>(res.getCode(), result);
    }

    public int reportX() throws IOException {
        return this.conn.sendCommand(64, this.aPassword, null, 2000, 10000).getCode();
    }

    public int reportZ() throws IOException {
        return this.conn.sendCommand(65, this.aPassword, null, 2000, 10000).getCode();
    }

    public int beep() throws IOException {
        return this.conn.sendCommand(19, this.oPassword, null).getCode();
    }

    public boolean isCutSupport() throws IOException {
        if (this.cutSupport == null) {
            this.requestPrinterAbilities();
        }
        return this.cutSupport;
    }

    public int cut(boolean fullCut) throws IOException {
        byte data = (byte)(!fullCut ? 1 : 0);
        return this.conn.sendCommand(37, this.oPassword, new byte[]{data}).getCode();
    }

    public int getPrintWidth() throws IOException {
        if (this.printWidth == null) {
            this.requestPrinterAbilities();
        }
        return this.printWidth;
    }

    public int openSession() throws IOException {
        return this.conn.sendCommand(224, this.oPassword, null).getCode();
    }

    public int feedCheck(int count) throws IOException {
        if (count < 0 || count > 255) {
            throw new IllegalArgumentException("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0432 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0435 \u043e\u0442 0 \u0434\u043e 255");
        }
        return this.conn.sendCommand(41, this.oPassword, new byte[]{2, (byte)count}).getCode();
    }

    public int printString(String str, boolean bold) throws IOException {
        if (str == null) {
            return 0;
        }
        if (bold) {
            str = StringUtils.getStringByLen(str, 20);
            byte[] data = new byte[1 + str.length()];
            data[0] = 2;
            byte[] bytes = str.getBytes("cp1251");
            System.arraycopy(bytes, 0, data, 1, bytes.length);
            return this.conn.sendCommand(18, this.oPassword, data).getCode();
        }
        str = StringUtils.getStringByLen(str, 40);
        byte[] data = new byte[1 + str.length()];
        data[0] = 2;
        byte[] bytes = str.getBytes("cp1251");
        System.arraycopy(bytes, 0, data, 1, bytes.length);
        return this.conn.sendCommand(23, this.oPassword, data).getCode();
    }

    public int printString(String str, int fontNum) throws IOException {
        if (str == null) {
            return 0;
        }
        str = StringUtils.getStringByLen(str, 60);
        byte[] data = new byte[2 + str.length()];
        data[0] = 2;
        data[1] = (byte)fontNum;
        byte[] bytes = str.getBytes("cp1251");
        System.arraycopy(bytes, 0, data, 2, bytes.length);
        return this.conn.sendCommand(47, this.oPassword, data).getCode();
    }

    public int continuePrint() throws IOException {
        return this.conn.sendCommand(176, this.oPassword, null).getCode();
    }

    public int cancelCheck() throws IOException {
        return this.conn.sendCommand(136, this.oPassword, null).getCode();
    }

    public Result<Short> checkNumber() throws IOException {
        byte[] data;
        R res = this.getOperationRegistry(152);
        if (res.getCode() == 0 && (data = res.getData()) != null && data.length == 3) {
            return new Result<Short>(res.getCode(), (short)((data[1] & 0xFF) + (data[2] << 8 & 0xFF00) + 1));
        }
        return new Result<Short>(res.getCode());
    }

    public R getOperationRegistry(int number) throws IOException {
        if (number < 0 || number > 255) {
            throw new IllegalArgumentException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c 0..255");
        }
        return this.conn.sendCommand(27, this.oPassword, new byte[]{(byte)number});
    }

    public int initTables() throws IOException {
        return this.conn.sendCommand(36, this.oPassword, null).getCode();
    }

    public R readTable(int idTable, int idRow, int idField) throws IOException {
        if (idTable < 0 || idTable > 255) {
            throw new IllegalArgumentException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0442 0 \u0434\u043e 255");
        }
        if (idRow < 0 || idRow > 65536) {
            throw new IllegalArgumentException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u0440\u044f\u0434\u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0442 0 \u0434\u043e 65536");
        }
        if (idField < 0 || idField > 255) {
            throw new IllegalArgumentException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u043f\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0442 0 \u0434\u043e 255");
        }
        byte[] data = new byte[]{(byte)(idTable & 0xFF), (byte)(idRow & 0xFF), (byte)(idRow >> 8 & 0xFF), (byte)(idField & 0xFF)};
        return this.conn.sendCommand(31, this.aPassword, data);
    }

    public int writeTable(int idTable, int idRow, int idField, byte[] value) throws IOException {
        if (value == null || value.length == 0 || value.length > 40) {
            throw new IllegalArgumentException("\u0417\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0434\u043b\u0438\u043d\u043e\u0439 \u043e\u0442 1 \u0434\u043e 40 \u0431\u0430\u0439\u0442\u043e\u0432");
        }
        if (idTable < 0 || idTable > 255) {
            throw new IllegalArgumentException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0442 0 \u0434\u043e 255");
        }
        if (idRow < 0 || idRow > 65536) {
            throw new IllegalArgumentException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u0440\u044f\u0434\u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0442 0 \u0434\u043e 65536");
        }
        if (idField < 0 || idField > 255) {
            throw new IllegalArgumentException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u043f\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0442 0 \u0434\u043e 255");
        }
        byte[] data = new byte[value.length + 4];
        data[0] = (byte)(idTable & 0xFF);
        data[1] = (byte)(idRow & 0xFF);
        data[2] = (byte)(idRow >> 8 & 0xFF);
        data[3] = (byte)(idField & 0xFF);
        System.arraycopy(value, 0, data, 4, value.length);
        return this.conn.sendCommand(30, this.aPassword, data).getCode();
    }

    public int writeTable(int idTable, int idRow, int idField, int value) throws IOException {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0442 0 \u0434\u043e 255");
        }
        return this.writeTable(idTable, idRow, idField, new byte[]{(byte)value});
    }

    public int openCheck(int type) throws IOException {
        if (type < 0 || type > 4) {
            throw new IllegalArgumentException("\u0422\u0438\u043f \u043e\u0442\u043a\u0440\u044b\u0432\u0430\u0435\u043c\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043d\u0435\u0432\u0435\u0440\u0435\u043d");
        }
        return this.conn.sendCommand(141, this.oPassword, new byte[]{(byte)type}).getCode();
    }

    public int closeCheck(int cash, int cashbackcard, int cashless) throws IOException {
        byte[] data = new byte[66];
        data[0] = (byte)(cash & 0xFF);
        data[1] = (byte)(cash >> 8 & 0xFF);
        data[2] = (byte)(cash >> 16 & 0xFF);
        data[3] = (byte)(cash >> 24 & 0xFF);
        data[4] = 0;
        data[5] = (byte)(cashbackcard & 0xFF);
        data[6] = (byte)(cashbackcard >> 8 & 0xFF);
        data[7] = (byte)(cashbackcard >> 16 & 0xFF);
        data[8] = (byte)(cashbackcard >> 24 & 0xFF);
        data[9] = 0;
        data[10] = 0;
        data[11] = 0;
        data[12] = 0;
        data[13] = 0;
        data[14] = 0;
        data[15] = (byte)(cashless & 0xFF);
        data[16] = (byte)(cashless >> 8 & 0xFF);
        data[17] = (byte)(cashless >> 16 & 0xFF);
        data[18] = (byte)(cashless >> 24 & 0xFF);
        data[19] = 0;
        data[20] = 0;
        data[21] = 0;
        data[22] = 0;
        data[23] = 0;
        data[24] = 0;
        data[25] = 0;
        byte[] str = StringUtils.getStringByLen("", 40).getBytes("cp1251");
        System.arraycopy(str, 0, data, 26, 40);
        return this.conn.sendCommand(133, this.oPassword, data).getCode();
    }

    public int addOperation(int type, String name, int price, int count, int section) throws IOException {
        if (type < 128 || type > 131) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438");
        }
        if (section < 0 || section > 16) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043e\u0442\u0434\u0435\u043b\u0430");
        }
        if (name == null || name.isEmpty()) {
            name = "\u043d/\u0443";
        }
        name = StringUtils.getStringByLen(name, 40);
        byte[] bname = null;
        try {
            bname = name.getBytes("cp1251");
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] data = new byte[15 + (bname == null ? 0 : bname.length)];
        data[0] = (byte)(count & 0xFF);
        data[1] = (byte)(count >> 8 & 0xFF);
        data[2] = (byte)(count >> 16 & 0xFF);
        data[3] = (byte)(count >> 24 & 0xFF);
        data[4] = 0;
        data[5] = (byte)(price & 0xFF);
        data[6] = (byte)(price >> 8 & 0xFF);
        data[7] = (byte)(price >> 16 & 0xFF);
        data[8] = (byte)(price >> 24 & 0xFF);
        data[9] = 0;
        data[10] = (byte)section;
        data[11] = 0;
        data[12] = 0;
        data[13] = 0;
        data[14] = 0;
        if (bname != null) {
            System.arraycopy(bname, 0, data, 15, bname.length);
        }
        return this.conn.sendCommand(type, this.oPassword, data).getCode();
    }

    private void requestPrinterAbilities() throws IOException {
        Result<Info> yr = this.getInfo();
        if (yr.getError() == 0) {
            this.cutSupport = !this.cutUnsupportModels.contains(yr.getData().getModel());
            this.printWidth = this.printWidthModels.get(yr.getData().getModel());
            if (this.printWidth == null) {
                this.printWidth = 40;
            }
        }
    }

    public int openText() throws IOException {
        return this.conn.sendCommand(226, this.oPassword, null).getCode();
    }

    public int closeText() throws IOException {
        return this.conn.sendCommand(227, this.oPassword, null).getCode();
    }

    public int getFontCount() throws IOException {
        R res = this.conn.sendCommand(38, this.aPassword, new byte[]{1});
        if (res.getCode() == 0) {
            return res.getData()[4];
        }
        return 0;
    }

    public FontData getFont(int fontNum) throws IOException {
        R res = this.conn.sendCommand(38, this.aPassword, new byte[]{(byte)fontNum});
        if (res.getCode() == 0) {
            return new FontData(fontNum, BU.csle((byte[])res.getData(), (int)0), res.getData()[2], res.getData()[3]);
        }
        return null;
    }

    private Date getDate(int day, int month, int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2000 + year);
        cal.set(2, month);
        cal.set(5, day);
        return cal.getTime();
    }

    private static Date getDate(int day, int month, int year, int hour, int min, int sec) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2000 + year);
        cal.set(2, month);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, min);
        cal.set(13, sec);
        return cal.getTime();
    }

    private byte[] getPassword(int password) {
        byte[] pass = new byte[]{(byte)(password & 0xFF), (byte)(password >> 8 & 0xFF), (byte)(password >> 16 & 0xFF), (byte)(password >> 24 & 0xFF)};
        return pass;
    }

    public ZReportInfo readZReportInfo() {
        return null;
    }

    public int getUnsentDocs() throws IOException {
        R ret = this.conn.sendCommand(65343, this.oPassword, null);
        if (ret.getCode() != 0) {
            throw new IOException("Bad errorcode: " + ret.getCode());
        }
        return BU.csle((byte[])ret.getData(), (int)0);
    }

    private int toUInt32(byte[] bint) {
        int res = 0;
        for (int i = 0; i < bint.length; ++i) {
            res = (int)((long)res + (((long)bint[i] & 0xFFL) << 8 * i));
        }
        return res;
    }

    public InfoExchangeStatus getInfoExchangeStatus() throws IOException {
        R res = this.conn.sendCommand(65337, this.aPassword, null);
        InfoExchangeStatus status = new InfoExchangeStatus();
        if (res.getData() != null) {
            byte[] data = res.getData();
            status.setTransportConnectionExist((data[0] & 1) == 1);
            status.setOfdMessageExist((data[0] & 2) == 1);
            status.setWaitingAnswer((data[0] & 4) == 1);
            status.setOfdCommandExist((data[0] & 8) == 1);
            status.setConnactionChanged((data[0] & 0x10) == 1);
            status.setWaitingCommandAnswer((data[0] & 0x20) == 1);
            status.setReadingMessageStatus(data[1]);
            int messageQuantity = data[2] << 8 & 65280 + data[3] & 0xFF;
            status.setMessageQuantity(messageQuantity);
            status.setFirstMessageNumber(data[3] << 32 & -16777216 + (data[4] << 16) & 0xFF0000 + (data[5] << 8) & 65280 + data[6] & 0xFF);
            status.setFirstMessageDate(Api.getDate(data[7], data[8], data[9], data[10], data[11], data[12]));
        }
        return status;
    }

    public int addReqesit(String address) throws IOException {
        return this.sendTLV(1008, address.getBytes("cp1251"));
    }

    public int sendTLV(int tag, byte[] value) throws IOException {
        int length = 4 + value.length;
        if (length > 250) {
            throw new IOException("Struct length more than 250 bytes");
        }
        byte[] tlvStruct = new byte[4 + value.length];
        BU.ssle((byte[])tlvStruct, (int)0, (int)tag);
        BU.ssle((byte[])tlvStruct, (int)2, (int)value.length);
        System.arraycopy(value, 0, tlvStruct, 4, value.length);
        R result = this.conn.sendCommand(65292, this.oPassword, tlvStruct);
        return result.getCode();
    }
}

