/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.proto.essp;

import java.io.IOException;
import java.security.InvalidKeyException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.proto.essp.Crc16;
import ru.softlogic.hardware.proto.essp.SSPLayer;
import ru.softlogic.hardware.proto.essp.TransportLayer;
import ru.softlogic.hardware.proto.essp.eSSPException;
import ru.softlogic.io.utils.BU;

public class eSSPLayer
implements TransportLayer {
    private SSPLayer transportLayer;
    private Crc16 crc16;
    private long seq = -1L;
    private Logger log;
    private SecretKeySpec key;
    private Cipher cipher;

    public eSSPLayer(SSPLayer transportLayer, byte[] key, Crc16 crc16, Logger log) throws eSSPException {
        if (transportLayer == null) {
            throw new NullPointerException("eSSPTransportLayer");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (crc16 == null) {
            throw new NullPointerException("Crc16");
        }
        if (key.length != 16) {
            throw new IllegalArgumentException("Key size must be 16 byte lenght");
        }
        if (log == null) {
            throw new NullPointerException("Logger");
        }
        this.transportLayer = transportLayer;
        byte[] key1 = new byte[16];
        for (int i = 0; i < 16; ++i) {
            key1[i] = key[15 - i];
        }
        this.key = new SecretKeySpec(key1, "AES");
        this.crc16 = crc16;
        this.log = log;
        try {
            this.cipher = Cipher.getInstance("AES/ECB/NoPadding", "BC");
        }
        catch (Exception ex) {
            throw new eSSPException(ex);
        }
    }

    @Override
    public byte[] sendPacket(int cmd, byte[] data, int slaveId) throws IOException {
        return this.sendPacket(cmd, data, slaveId, 1000);
    }

    @Override
    public byte[] sendPacket(int cmd, byte[] data, int slaveId, int timeout) throws IOException {
        this.seq = (this.seq + 1L) % 0xFFFFFFA0L;
        this.log.debug((Object)("host seq=" + this.seq));
        byte[] pkg = this.createEncryptionPacket(cmd, data, this.seq);
        this.log.debug((Object)(">p=" + BU.toString((byte[])pkg)));
        byte[] cryptoRequest = this.encrypt(pkg);
        this.log.debug((Object)(">c=" + BU.toString((byte[])cryptoRequest)));
        byte[] cryptoResponce = this.transportLayer.sendPacket(126, cryptoRequest, slaveId, timeout);
        this.log.debug((Object)("<c=" + BU.toString((byte[])cryptoResponce)));
        if ((cryptoResponce[0] & 0xFF) == 126) {
            byte[] out = this.decrypt(cryptoResponce);
            this.log.debug((Object)("<p=" + BU.toString((byte[])out)));
            if (!this.crc16.checkCrc16(out, 0)) {
                throw new IOException("Crc of crypto package s't correct: " + BU.toString((byte[])out));
            }
            int hdwSeq = BU.cile((byte[])out, (int)1);
            this.log.debug((Object)("hardware seq=" + hdwSeq));
            byte[] result = new byte[out[0]];
            System.arraycopy(out, 5, result, 0, result.length);
            return result;
        }
        return cryptoResponce;
    }

    private byte[] encrypt(byte[] data) throws IOException {
        try {
            this.cipher.init(1, this.key);
            byte[] crypto = this.cipher.update(data);
            return crypto;
        }
        catch (InvalidKeyException ex) {
            throw new IOException(ex);
        }
    }

    private byte[] decrypt(byte[] data) throws IOException {
        try {
            this.cipher.init(2, this.key);
            byte[] crypto = this.cipher.update(data, 1, data.length - 1);
            return crypto;
        }
        catch (InvalidKeyException ex) {
            throw new IOException(ex);
        }
    }

    private byte[] createEncryptionPacket(int cmd, byte[] data, long sequence) {
        int len = (data == null ? 0 : data.length) + 8;
        byte[] raw = new byte[len + (len % 16 == 0 ? 0 : 16 - len % 16)];
        raw[0] = (byte)(len - 7);
        raw[1] = (byte)(sequence & 0xFFL);
        raw[2] = (byte)(sequence >> 8 & 0xFFL);
        raw[3] = (byte)(sequence >> 16 & 0xFFL);
        raw[4] = (byte)(sequence >> 24 & 0xFFL);
        raw[5] = (byte)cmd;
        if (data != null) {
            System.arraycopy(data, 0, raw, 6, data.length);
        }
        int crc = this.crc16.makeCrc16(raw, 0);
        raw[raw.length - 2] = (byte)(crc & 0xFF);
        raw[raw.length - 1] = (byte)(crc >> 8 & 0xFF);
        return raw;
    }
}

