/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.proto.essp;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.proto.essp.Crc16;
import ru.softlogic.hardware.proto.essp.Result;
import ru.softlogic.hardware.proto.essp.SSPLayer;
import ru.softlogic.hardware.proto.essp.SSPUtils;
import ru.softlogic.hardware.proto.essp.eSSPException;
import ru.softlogic.hardware.proto.essp.eSSPLayer;
import ru.softlogic.hardware.proto.essp.m;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.utils.BU;

public class SSPApi {
    public static final byte[] ITL_KEY = new byte[]{1, 35, 69, 103, 1, 35, 69, 103};
    private SerialPort port;
    private int slaveId;
    private SerialParams[] params;
    private Crc16 crc16;
    private SSPLayer tl;
    private Logger log;

    public SSPApi(SerialPort port, int slaveId, Logger log) {
        if (port == null) {
            throw new NullPointerException("SerialPort");
        }
        if (log == null) {
            throw new NullPointerException("Logger");
        }
        this.port = port;
        this.slaveId = slaveId;
        this.log = log;
        this.params = new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)};
        this.crc16 = new Crc16();
        this.tl = new SSPLayer(port, this.crc16, log);
        this.tl.setAttemptsCount(3);
    }

    public int setHostProtocol(int protocol) throws IOException {
        byte[] response = this.tl.sendPacket(6, new byte[]{(byte)protocol}, this.slaveId);
        int result = SSPUtils.getError(response);
        return result;
    }

    public eSSPLayer createEncryptedLayer(byte[] vendorKey) throws IOException, eSSPException {
        if (vendorKey == null) {
            throw new NullPointerException("vendor key");
        }
        if (vendorKey.length != 8) {
            throw new IllegalArgumentException("key must be 8 byte length");
        }
        this.log.debug((Object)"init crypto layer");
        Random rnd = new Random();
        BigInteger gen = BigInteger.probablePrime(31, rnd);
        BigInteger mod = BigInteger.probablePrime(31, rnd);
        BigInteger exp = BigInteger.probablePrime(31, rnd);
        BigInteger numA = gen.modPow(exp, mod);
        this.checkResult(this.setGenerator(gen.intValue()));
        this.checkResult(this.setModulus(mod.intValue()));
        Result<byte[]> res = this.requestKeyExchange(numA.intValue());
        this.checkResult(res.getError());
        if (res.getData() == null || res.getData().length == 0) {
            throw new IOException("Device key not received");
        }
        if (res.getData().length != 8) {
            throw new IOException("Device key must be 64 bits lenght");
        }
        this.log.debug((Object)("b=" + BU.toString((byte[])res.getData())));
        BigInteger numB = new BigInteger(res.getData());
        BigInteger commonKey = numB.modPow(exp, mod);
        this.log.debug((Object)("secret key=" + commonKey));
        byte[] key = commonKey.toByteArray();
        byte[] key16 = new byte[16];
        System.arraycopy(key, 0, key16, 4, key.length);
        System.arraycopy(vendorKey, 0, key16, 8, vendorKey.length);
        this.log.debug((Object)("finalkey=" + BU.toString((byte[])key16)));
        return new eSSPLayer(this.tl, key16, this.crc16, this.log);
    }

    public Result<Integer> getSerial() throws IOException {
        byte[] res = this.tl.sendPacket(12, null, this.slaveId);
        int error = SSPUtils.getError(res);
        if (error == 240) {
            int val = BU.cibe((byte[])res, (int)1);
            if (val < 0) {
                this.log.info((Object)("Serial answer: " + BU.toString((byte[])res)));
            }
            return new Result<Integer>(error, val);
        }
        return new Result<Integer>(error);
    }

    public int reset() throws IOException {
        byte[] res = this.tl.sendPacket(1, null, this.slaveId, 50000);
        return SSPUtils.getError(res);
    }

    public int sync() throws IOException {
        byte[] res = this.tl.sendPacket(17, null, this.slaveId);
        return SSPUtils.getError(res);
    }

    public int enable() throws IOException {
        byte[] res = this.tl.sendPacket(10, null, this.slaveId);
        return SSPUtils.getError(res);
    }

    public int disable() throws IOException {
        byte[] res = this.tl.sendPacket(9, null, this.slaveId);
        return SSPUtils.getError(res);
    }

    public Result<byte[]> poll() throws IOException {
        byte[] res = this.tl.sendPacket(7, null, this.slaveId);
        int error = SSPUtils.getError(res);
        if (error == 240) {
            byte[] data = new byte[res.length - 1];
            System.arraycopy(res, 1, data, 0, data.length);
            return new Result<byte[]>(error, data);
        }
        return new Result<byte[]>(error);
    }

    public Result<String> getFirmware() throws IOException {
        byte[] res = this.tl.sendPacket(32, null, this.slaveId);
        int error = SSPUtils.getError(res);
        if (error == 240) {
            byte[] data = new byte[res.length - 1];
            System.arraycopy(res, 1, data, 0, data.length);
            return new Result<String>(error, new String(data));
        }
        return new Result<String>(error);
    }

    public Result<Integer> getUnitType() throws IOException {
        byte[] res = this.tl.sendPacket(5, null, this.slaveId);
        this.log.info((Object)BU.toString((byte[])res));
        int error = SSPUtils.getError(res);
        if (error == 240) {
            return new Result<Integer>(error, BU.c((byte)res[1]));
        }
        return new Result<Integer>(error);
    }

    public void open() throws IOException {
        this.port.open();
        this.port.setFlow(Flow.None);
        this.port.setRTS(false);
    }

    public void close() {
        this.port.close();
    }

    private int setGenerator(int data) throws IOException {
        this.log.debug((Object)"set generator");
        return SSPUtils.getError(this.tl.sendPacket(74, SSPUtils.intToByte8(data), this.slaveId));
    }

    private int setModulus(int data) throws IOException {
        this.log.debug((Object)"set modulus");
        return SSPUtils.getError(this.tl.sendPacket(75, SSPUtils.intToByte8(data), this.slaveId));
    }

    private Result<byte[]> requestKeyExchange(int data) throws IOException {
        this.log.debug((Object)"request key exchange");
        byte[] response = this.tl.sendPacket(76, SSPUtils.intToByte8(data), this.slaveId);
        int error = SSPUtils.getError(response);
        if (error == 240) {
            byte[] dt = new byte[response.length - 1];
            for (int i = 0; i < 8; ++i) {
                dt[i] = response[8 - i];
            }
            return new Result<byte[]>(error, dt);
        }
        return new Result<byte[]>(error);
    }

    private void checkResult(int result) throws IOException {
        if (result != 240) {
            throw new IOException(m.get(result));
        }
    }
}

