/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.proto.essp;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.proto.essp.Banknote;
import ru.softlogic.hardware.proto.essp.SSPException;
import ru.softlogic.hardware.proto.essp.SSPUtils;
import ru.softlogic.hardware.proto.essp.TransportLayer;
import ru.softlogic.hardware.proto.essp.ValidatorSetup;
import ru.softlogic.io.utils.BU;

public class Nv200Api {
    private TransportLayer layer;
    private int slaveId;
    private Logger log;
    private int proto;

    public Nv200Api(TransportLayer layer, int slaveId, int proto, Logger log) {
        if (layer == null) {
            throw new NullPointerException("eSSPLayer");
        }
        this.layer = layer;
        this.slaveId = slaveId;
        if (proto != 6) {
            throw new IllegalArgumentException("Proto must be 6");
        }
        this.proto = proto;
        this.log = log;
    }

    public int enable() throws IOException {
        byte[] res = this.layer.sendPacket(10, null, this.slaveId);
        return SSPUtils.getError(res);
    }

    public int disable() throws IOException {
        byte[] res = this.layer.sendPacket(9, null, this.slaveId);
        return SSPUtils.getError(res);
    }

    public int getLastRejectCode() throws IOException, SSPException {
        byte[] res = this.layer.sendPacket(23, null, this.slaveId);
        int error = SSPUtils.getError(res);
        if (error == 240) {
            return BU.c((byte)res[1]);
        }
        throw new SSPException(error);
    }

    public byte[] poll() throws IOException, SSPException {
        byte[] res = this.layer.sendPacket(7, null, this.slaveId);
        int error = SSPUtils.getError(res);
        if (error == 240) {
            byte[] data = new byte[res.length - 1];
            System.arraycopy(res, 1, data, 0, data.length);
            return data;
        }
        throw new SSPException(error);
    }

    public int setChannelInhibits(int mask) throws IOException {
        byte[] res = this.layer.sendPacket(2, new byte[]{BU.c((int)mask)}, this.slaveId);
        return SSPUtils.getError(res);
    }

    public int displayOn() throws IOException {
        byte[] res = this.layer.sendPacket(3, null, this.slaveId);
        return SSPUtils.getError(res);
    }

    public ValidatorSetup getDeviceSetup() throws IOException, SSPException {
        byte[] res = this.layer.sendPacket(5, null, this.slaveId);
        this.log.info((Object)BU.toString((byte[])res));
        int error = SSPUtils.getError(res);
        if (error == 240) {
            int multiplier;
            byte unitType = res[1];
            if (unitType != 6 && unitType != 0) {
                throw new IOException("Wrong device type: " + unitType + ", must be 6(SMART Payout)");
            }
            String firmvare = new String(res, 2, 2) + "." + new String(res, 4, 2);
            String countyCode = new String(res, 6, 3);
            int n = BU.c((byte)res[12]);
            int protocol = BU.c((byte)res[16 + 2 * n]);
            int[] secures = new int[n];
            for (int i = 0; i < n; ++i) {
                secures[i] = BU.c((byte)res[13 + n + i]);
            }
            Banknote[] banknotes = new Banknote[n];
            if (protocol >= 6) {
                multiplier = SSPUtils.byteToInt(res, 13 + n * 2, 3);
                for (int i = 0; i < n; ++i) {
                    banknotes[i] = new Banknote(SSPUtils.byteToInt(res, 17 + n * 5 + i * 4, 4), new String(res, 17 + n * 2 + i * 3, 3));
                }
            } else {
                multiplier = BU.c((byte)res[11]);
                for (int i = 0; i < n; ++i) {
                    banknotes[i] = new Banknote(BU.c((byte)res[13 + i]) * multiplier, countyCode);
                }
            }
            return new ValidatorSetup(unitType, firmvare, countyCode, banknotes, secures, multiplier, protocol);
        }
        throw new SSPException(error);
    }
}

