/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.proto.cctalk.v2.coinacceptor;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.proto.cctalk.v2.BusyException;
import ru.softlogic.hardware.proto.cctalk.v2.CoreApi;
import ru.softlogic.hardware.proto.cctalk.v2.NakException;
import ru.softlogic.hardware.proto.cctalk.v2.coinacceptor.BufferedCredit;
import ru.softlogic.hardware.proto.cctalk.v2.coinacceptor.EventPair;
import ru.softlogic.hardware.proto.cctalk.v2.coinacceptor.PoolingPriority;
import ru.softlogic.hardware.proto.cctalk.v2.coinacceptor.SelfCheckState;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class CoinAcceptorApi
extends CoreApi {
    public CoinAcceptorApi(SerialPort port, Logger log, int dest) {
        super(port, log, dest);
    }

    public int requestStatus() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(248);
        return BU.c((byte)data[0]);
    }

    public PoolingPriority requestPoolingPriority() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(249);
        return new PoolingPriority(BU.c((byte)data[0]), BU.c((byte)data[1]));
    }

    public int requestDatabaseVersion() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(243);
        return BU.c((byte)data[0]);
    }

    public void testSolenoids(int bitmask) throws IOException, NakException, BusyException {
        this.conn.sendMessage(240, this.conv(bitmask));
    }

    public void testOutputLines(int bitmask) throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(238, this.conv(bitmask));
    }

    public byte[] readInputLines() throws IOException, NakException, BusyException {
        return this.conn.sendMessage(237, true);
    }

    public int readOptoStates() throws IOException, NakException, BusyException {
        return BU.c((byte)this.conn.sendMessage(236)[0]);
    }

    public void modifyInhibitStatus(int mask) throws IOException, NakException, BusyException {
        this.conn.sendMessage(231, new byte[]{(byte)(mask & 0xFF), (byte)(mask >> 8 & 0xFF)});
    }

    public int requestInhibitStatus() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(230);
        return BU.csle((byte[])data, (int)0);
    }

    public void latchOutputLines(int bitmask) throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(233, this.conv(bitmask));
        this.log.debug((Object)("latchOutputLines: " + BU.toString((byte[])data)));
    }

    public SelfCheckState performSelfCheck() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(232);
        return new SelfCheckState(BU.c((byte)data[0]), data.length > 1 ? Integer.valueOf(BU.c((byte)data[1])) : null);
    }

    public BufferedCredit readBufferedCredit() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(229);
        BufferedCredit bc = new BufferedCredit();
        bc.setEventsCount(data[0] & 0xFF);
        EventPair[] eps = new EventPair[5];
        for (int i = 0; i < 5; ++i) {
            EventPair ep;
            eps[i] = ep = new EventPair(data[i * 2 + 1] & 0xFF, data[i * 2 + 2] & 0xFF);
        }
        bc.setEvents(eps);
        return bc;
    }

    public void modifyMasterInhibitStatus(int mask) throws IOException, NakException, BusyException {
        this.conn.sendMessage(228, this.conv(mask));
    }

    public int requestMasterInhibitStatus() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(227);
        return data[0];
    }

    public Integer requestInsertionCounter() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(226, true);
        if (data != null) {
            return data[0] + (data[1] >> 8) + (data[2] >> 16);
        }
        return null;
    }

    public Integer requestAcceptCounter() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(225, true);
        if (data != null) {
            return data[0] + (data[1] >> 8) + (data[2] >> 16);
        }
        return null;
    }

    public Integer requestRejectCounter() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(194, true);
        if (data != null) {
            return BU.c((byte)data[0]) + (BU.c((byte)data[1]) >> 8) + (BU.c((byte)data[2]) >> 16);
        }
        return null;
    }

    public Integer requestFraudCounter() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(193, true);
        if (data != null) {
            return BU.c((byte)data[0]) + (BU.c((byte)data[1]) >> 8) + (BU.c((byte)data[2]) >> 16);
        }
        return null;
    }

    public void modifySorterOverrideStatus(int mask) throws IOException, NakException, BusyException {
        this.conn.sendMessage(222, this.conv(mask));
    }

    public int requestSorterOverrideStatus() throws IOException, NakException, BusyException {
        return BU.c((byte)this.conn.sendMessage(221)[0]);
    }

    public void setAcceptLimit(int limit) throws IOException, NakException, BusyException {
        byte[] res = this.conn.sendMessage(135, this.conv(limit));
        this.log.debug((Object)("setAcceptLimit: " + BU.toString((byte[])res)));
    }

    public int requestSorterPaths(int position) throws IOException, NakException, BusyException {
        byte[] res = this.conn.sendMessage(209, this.conv(position));
        return BU.c((byte)res[0]);
    }

    public void modifySorterPaths(int position, int path) throws IOException, NakException, BusyException {
        byte[] res = this.conn.sendMessage(210, this.conv(position, path));
    }

    public int requestDefaultSorterPath() throws IOException, NakException, BusyException {
        byte[] res = this.conn.sendMessage(188);
        return BU.c((byte)res[0]);
    }

    public void modifyDefaultSorterPath(int path) throws IOException, NakException, BusyException {
        byte[] res = this.conn.sendMessage(189, this.conv(path));
    }

    public Integer requestSecuritySettings(int coinId) throws IOException, NakException, BusyException {
        byte[] res = this.conn.sendMessage(180, this.conv(coinId), true, null, null);
        if (res != null) {
            return BU.c((byte)res[0]);
        }
        return null;
    }

    public int modifySecuritySettings(int coinId, int settings) throws IOException, NakException, BusyException {
        byte[] res = this.conn.sendMessage(181, this.conv(coinId, settings));
        return BU.c((byte)res[0]);
    }

    public String requestCoinId(int position) throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(184, this.conv(position));
        try {
            String res = new String(data);
            if ("......".equals(res)) {
                return null;
            }
            return res;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Integer requestThermistorReading() throws IOException, NakException, BusyException {
        byte[] res = this.conn.sendMessage(173, true);
        if (res != null) {
            return BU.c((byte)res[0]);
        }
        return null;
    }
}

