/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.software;

import java.io.IOException;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.modem.ModemException;
import ru.softlogic.hardware.device.modem.batch.ModemIniter;
import ru.softlogic.hardware.device.modem.drivers.GenericModemApi;
import ru.softlogic.hardware.device.modem.resources.ModemHelper;
import ru.softlogic.hardware.device.watchdog.BaseWatchDog;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.ppp.ConnectionManager;
import ru.softlogic.ppp.ManagerFactory;
import ru.softlogic.ppp.OperationResult;
import ru.softlogic.system.util.os.OsApi;

public class SoftwareWatchDog
extends BaseWatchDog {
    private GenericModemApi modemApi;
    private DeviceInfo deviceInfo;
    private Logger log;
    private ConnectionManager manager;
    private SerialPort port;

    public SoftwareWatchDog(SerialPort serialPort) {
        if (serialPort == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.modemApi = new GenericModemApi(serialPort);
        this.deviceInfo = new DeviceInfo(DeviceType.Software);
        this.deviceInfo.setModel("SoftwareWatchDog");
        this.deviceInfo.setPort(serialPort.getName());
        this.port = serialPort;
        this.log = Logger.getLogger((String)"watchdog");
        this.manager = ManagerFactory.getInstance().getManager();
        this.log.info((Object)"Created SoftwareWatchDog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetModem() throws IOException {
        this.log.info((Object)"\u041f\u044b\u0442\u0430\u044e\u0441\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043c\u043e\u0434\u0435\u043c");
        ConnectionManager connectionManager = this.manager;
        synchronized (connectionManager) {
            for (int i = 0; i < 7; ++i) {
                try {
                    this.log.info((Object)"\u041f\u044b\u0442\u0430\u044e\u0441\u044c \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c ppp \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435");
                    Logger.getLogger((String)"ppp").info((Object)"\u041f\u044b\u0442\u0430\u044e\u0441\u044c \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c ppp \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435");
                    OperationResult or = this.manager.disconnectAll();
                    this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0430: " + or));
                    Logger.getLogger((String)"ppp").info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0430: " + or));
                    this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u043f\u043e\u0440\u0442 \u043c\u043e\u0434\u0435\u043c\u0430: ");
                    this.modemApi.open();
                    new ModemIniter(this.modemApi).process();
                    this.log.info((Object)"Get modem vendor");
                    String vendor = null;
                    try {
                        vendor = this.modemApi.getVendor();
                        this.log.info((Object)("vendor: " + vendor + ", turn off gprs module"));
                    }
                    catch (ModemException ex) {
                        vendor = "";
                    }
                    OsApi.getInstance().rebootModem(this.port.getName() + " " + ModemHelper.getPowerOffRequest(vendor));
                    this.log.info((Object)"\u041a\u043e\u043c\u0430\u043d\u0434\u044b \u043f\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043c\u043e\u0434\u0435\u043c\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u044b");
                    break;
                }
                catch (Exception ex) {
                    this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043c\u043e\u0434\u0435\u043c\u0430", (Throwable)ex);
                }
                finally {
                    this.modemApi.close();
                }
                try {
                    Thread.sleep(new Random().nextInt(2000));
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        this.log.info((Object)"\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u043e\u0439 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043c\u043e\u0434\u0435\u043c\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430");
    }

    @Override
    public DeviceInfo getInfo() {
        return this.deviceInfo;
    }
}

