/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.softlogic;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.watchdog.BaseWatchDog;
import ru.softlogic.hardware.device.watchdog.softlogic.SoftLogicApi;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.system.util.ThreadUtil;

public class SoftLogicWatchDog
extends BaseWatchDog {
    private final SoftLogicApi api;
    private final Logger log;
    DeviceInfo info;

    public SoftLogicWatchDog(SerialPort serialPort) {
        this.api = new SoftLogicApi(serialPort);
        this.info = new DeviceInfo(DeviceType.SoftLogic);
        this.info.setVendor("SoftLogic");
        this.info.setPort(serialPort.getName());
        this.log = Logger.getLogger((String)"watchdog");
        this.log.setAdditivity(false);
        Thread th = new Thread((Runnable)new WatchDogThread(), "SoftLogicWatchDogPinger");
        th.setDaemon(true);
        th.start();
    }

    @Override
    public synchronized void resetModem() throws IOException {
        try {
            this.api.open();
            this.api.resetModem();
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            this.api.close();
        }
    }

    @Override
    public synchronized DeviceInfo getInfo() {
        try {
            this.api.open();
            this.info.setModel(this.api.getVersion());
            this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0438\u043c\u044f \u0442\u0430\u0439\u043c\u0435\u0440\u0430: " + this.info.getModel()));
        }
        catch (Exception e) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f: ", (Throwable)e);
            this.info.setModel("SoftLogic");
        }
        finally {
            this.api.close();
        }
        return this.info;
    }

    private synchronized void startTimer() throws IOException {
        try {
            this.api.open();
            this.api.startTimer();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.api.close();
        }
    }

    private synchronized void stopTimer() {
        try {
            this.api.open();
            this.api.stopTimer();
        }
        catch (Exception e) {
            this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0442\u0430\u0439\u043c\u0435\u0440\u0430: " + e.getMessage()));
        }
        finally {
            this.api.close();
        }
    }

    private class WatchDogThread
    implements Runnable {
        private WatchDogThread() {
        }

        @Override
        public void run() {
            SoftLogicWatchDog.this.log.info((Object)"Start thread");
            try {
                SoftLogicWatchDog.this.startTimer();
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        SoftLogicWatchDog.this.startTimer();
                    }
                    catch (IOException ex) {
                        SoftLogicWatchDog.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u0431\u0440\u043e\u0441\u0435 \u0442\u0430\u0439\u043c\u0435\u0440\u0430: ", (Throwable)ex);
                    }
                    ThreadUtil.sleep((long)10000L);
                }
            }
            catch (IOException ex) {
                SoftLogicWatchDog.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0443\u0441\u043a\u0435 \u0442\u0430\u0439\u043c\u0435\u0440\u0430", (Throwable)ex);
            }
            finally {
                SoftLogicWatchDog.this.stopTimer();
            }
            SoftLogicWatchDog.this.log.info((Object)"Stop thread");
        }
    }
}

