/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.softlogic;

import i18n.B;
import java.io.IOException;
import java.text.MessageFormat;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class SoftLogicApi
implements SerialDeviceApi {
    private SerialPort serialPort;
    private SerialParams[] serialParams;
    private int attempts = 3;
    private static final int MAX_LEN = 200;

    public SoftLogicApi(SerialPort serialPort) {
        if (serialPort == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.serialPort = serialPort;
        this.serialPort.setTimeout(300);
        this.serialParams = new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)};
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return this.serialParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (preferred) {
            this.attempts = 2;
            for (SerialParams params : this.getAvailableParameters()) {
                try {
                    this.serialPort.putParams(params);
                    this.open();
                    this.getVersion();
                    DeviceType deviceType = null;
                    return deviceType;
                }
                catch (Exception exception) {
                }
                finally {
                    this.close();
                }
            }
        }
        throw new NoSuchDeviceException(MessageFormat.format(B.log((String)"hdw.scan.not-found"), new Object[]{this.serialPort.getName(), this.getDeviceType()}));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.SoftLogic;
    }

    @Override
    public void open() throws IOException {
        this.serialPort.open();
        this.serialPort.setFlow(Flow.None);
    }

    @Override
    public void close() {
        this.serialPort.close();
    }

    public String getVersion() throws IOException {
        byte[] res = this.sendCommand((byte)48, null);
        return "SoftLogic " + res[0] + "." + res[1];
    }

    public int resetModem() throws IOException {
        byte[] res = this.sendCommand((byte)16, new byte[]{10});
        return res[0];
    }

    public int reset() throws IOException {
        byte[] res = this.sendCommand((byte)17, new byte[]{10});
        return res[0];
    }

    public int powerOff() throws IOException {
        byte[] res = this.sendCommand((byte)18, new byte[]{10});
        return res[0];
    }

    public int setPowerControl(boolean enable) throws IOException {
        byte[] res = enable ? this.sendCommand((byte)64, null) : this.sendCommand((byte)65, null);
        return res[0];
    }

    public int startTimer() throws IOException {
        byte[] res = this.sendCommand((byte)32, new byte[]{60});
        return res[0];
    }

    public int stopTimer() throws IOException {
        byte[] res = this.sendCommand((byte)33, new byte[]{60});
        return res[0];
    }

    private byte[] sendCommand(byte command, byte[] data) throws IOException {
        IOException lastException = null;
        for (int j = 0; j < this.attempts; ++j) {
            try {
                int bt;
                int len = 4 + (data == null ? 0 : data.length);
                byte[] request = new byte[len];
                request[0] = 120;
                request[1] = (byte)(len - 2);
                request[2] = command;
                int shift = 3;
                if (data != null) {
                    for (int i = 0; i < data.length; ++i) {
                        request[shift++] = data[i];
                    }
                }
                byte crc = 0;
                for (int i = 0; i < request.length - 1; ++i) {
                    crc = (byte)(crc + request[i]);
                }
                request[shift] = crc;
                this.serialPort.write(request);
                int z = 0;
                do {
                    bt = this.serialPort.readByte();
                    if (++z <= 200) continue;
                    throw new IOException("Start byte not found");
                } while (bt != 120);
                bt = this.serialPort.readByte();
                byte[] responce = new byte[bt + 2];
                responce[0] = 120;
                responce[1] = (byte)bt;
                byte[] oth = this.serialPort.read(bt);
                System.arraycopy(oth, 0, responce, 2, oth.length);
                crc = 0;
                for (int i = 0; i < responce.length - 1; ++i) {
                    crc = (byte)(crc + responce[i]);
                }
                if (crc != responce[responce.length - 1]) {
                    throw new IOException("CRC failed");
                }
                byte[] result = new byte[responce.length - 3];
                for (int i = 0; i < responce.length - 3; ++i) {
                    result[i] = responce[i + 2];
                }
                return result;
            }
            catch (IOException ex) {
                lastException = ex;
                continue;
            }
        }
        throw new IOException("I/O error", lastException);
    }
}

