/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.osmp;

import java.io.IOException;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class OsmpApi
implements SerialDeviceApi {
    private SerialPort serialPort;
    private SerialParams[] serialParams;

    public OsmpApi(SerialPort serialPort) {
        if (serialPort == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.serialPort = serialPort;
        this.serialPort.setTimeout(300);
        this.serialParams = new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)};
    }

    @Override
    public final SerialParams[] getAvailableParameters() {
        return this.serialParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (preferred) {
            for (SerialParams params : this.getAvailableParameters()) {
                try {
                    this.serialPort.putParams(params);
                    this.open();
                    this.getVersion();
                    DeviceType deviceType = null;
                    return deviceType;
                }
                catch (Exception exception) {
                }
                finally {
                    this.close();
                }
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.serialPort.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public final DeviceType getDeviceType() {
        return DeviceType.Osmp;
    }

    @Override
    public final void open() throws IOException {
        this.serialPort.open();
        this.serialPort.setFlow(Flow.None);
    }

    @Override
    public final void close() {
        this.serialPort.close();
    }

    public final String getVersion() throws IOException {
        byte[] data = this.sendCommand((byte)1, 9);
        String result = new String(data, 0, data.length, "cp1251");
        return result;
    }

    public final int resetModem() throws IOException {
        byte[] data = this.sendCommand((byte)2, 1);
        return data[0];
    }

    public final int startTimer() throws IOException {
        byte[] data = this.sendCommand((byte)3, 1);
        return data[0];
    }

    public final int stopTimer() throws IOException {
        byte[] data = this.sendCommand((byte)4, 1);
        return data[0];
    }

    public final int resetTimer() throws IOException {
        byte[] data = this.sendCommand((byte)5, 1);
        return data[0];
    }

    public final int reboot() throws IOException {
        byte[] data = this.sendCommand((byte)-82, 1);
        return data[0];
    }

    private byte[] sendCommand(byte cmd, int len) throws IOException {
        this.serialPort.write(new byte[]{79, 83, 80, cmd});
        return this.serialPort.read(len);
    }
}

