/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.online;

import java.io.IOException;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.watchdog.BaseWatchDog;
import ru.softlogic.hardware.device.watchdog.online.OnlineApi;
import ru.softlogic.io.serial.SerialPort;

public class OnlineWatchDog
extends BaseWatchDog {
    private final OnlineApi api;
    private final DeviceInfo info;

    public OnlineWatchDog(SerialPort serialPort) {
        this.api = new OnlineApi(serialPort);
        this.info = new DeviceInfo(DeviceType.Online);
        this.info.setVendor("Online");
        this.info.setModel("Online");
        this.info.setPort(serialPort.getName());
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }

    @Override
    public synchronized void resetModem() throws IOException {
        try {
            this.api.open();
            this.api.turnOffModem();
            Thread.sleep(10000L);
            this.api.turnOnModem();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.api.close();
        }
    }
}

