/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.online;

import java.io.IOException;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class OnlineApi
implements SerialDeviceApi {
    private SerialPort serialPort;
    private SerialParams[] serialParams;

    public OnlineApi(SerialPort serialPort) {
        if (serialPort == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.serialPort = serialPort;
        this.serialPort.setTimeout(300);
        this.serialParams = new SerialParams[]{new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None)};
    }

    @Override
    public final SerialParams[] getAvailableParameters() {
        return this.serialParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (preferred) {
            for (SerialParams params : this.getAvailableParameters()) {
                try {
                    this.serialPort.putParams(params);
                    this.open();
                    this.getStatus();
                    DeviceType deviceType = null;
                    return deviceType;
                }
                catch (Exception exception) {
                }
                finally {
                    this.close();
                }
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.serialPort.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public final DeviceType getDeviceType() {
        return DeviceType.Online;
    }

    @Override
    public final void open() throws IOException {
        this.serialPort.open();
        this.serialPort.setFlow(Flow.None);
    }

    @Override
    public final void close() {
        this.serialPort.close();
    }

    public final void turnOffModem() throws IOException {
        this.serialPort.write((byte)88);
    }

    public final void turnOnModem() throws IOException {
        this.serialPort.write((byte)89);
    }

    public final int getStatus() throws IOException {
        this.serialPort.write((byte)-64);
        byte[] res = this.serialPort.read(1);
        if ((res[0] | 0x1F) == 223) {
            return res[0];
        }
        throw new IOException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043e\u0442\u0432\u0435\u0442\u0430");
    }
}

