/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.ldog;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.serial.SerialPort;

public class LDogConnector {
    private SerialPort port;
    private Logger log;

    public LDogConnector(SerialPort port) {
        if (port == null) {
            throw new NullPointerException("SerialPort");
        }
        this.port = port;
        this.log = Logger.getLogger((String)"watchdog");
        this.log.setAdditivity(false);
    }

    public byte[] sendCommand(int cmd, byte[] data) throws IOException {
        IOException last = null;
        byte[] request = new byte[4 + (data != null ? data.length : 0)];
        request[0] = 16;
        request[1] = (byte)cmd;
        if (data != null) {
            System.arraycopy(data, 0, request, 2, data.length);
        }
        request[request.length - 2] = this.getCrc(request);
        request[request.length - 1] = 13;
        this.log.debug((Object)("r>>" + ByteUtils.toString(request)));
        byte[] prequest = this.pack(request);
        this.log.debug((Object)("p>>" + ByteUtils.toString(prequest)));
        this.port.setTimeout(1000);
        this.port.write(prequest);
        for (int j = 0; j < 1; ++j) {
            try {
                for (int i = 0; i < 100; ++i) {
                    int address = this.port.readByte();
                    if (address == 144) {
                        LinkedList<Byte> presponse = new LinkedList<Byte>();
                        presponse.add((byte)-112);
                        int val = this.port.readByte();
                        while (val != 13) {
                            presponse.add((byte)val);
                            val = this.port.readByte();
                        }
                        presponse.add((byte)13);
                        this.log.debug((Object)("p<<" + ByteUtils.toString(presponse)));
                        byte[] response = this.unpack(presponse);
                        this.log.debug((Object)("r<<" + ByteUtils.toString(presponse)));
                        if (this.getCrc(response) != response[response.length - 2]) {
                            throw new IOException("CRC not correct");
                        }
                        if ((response[1] & 0x7F) != cmd) {
                            throw new IOException("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043e\u0442\u0432\u0435\u0442 \u043e\u0442 \u0434\u0440\u0443\u0433\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b");
                        }
                        byte[] result = new byte[response.length - 4];
                        System.arraycopy(response, 2, result, 0, result.length);
                        this.log.debug((Object)("<<" + ByteUtils.toString(result)));
                        return result;
                    }
                    this.log.debug((Object)("\u043c\u0443\u0441\u043e\u0440: " + String.format("0x%02x", address)));
                }
                throw new IOException("\u0421\u0442\u0430\u0440\u0442\u043e\u0432\u044b\u0439 \u0431\u0430\u0439\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            catch (IOException ex) {
                this.log.error((Object)ex, (Throwable)ex);
                last = ex;
                continue;
            }
        }
        throw new IOException(last);
    }

    private byte[] pack(byte[] data) {
        LinkedList<Byte> packed = new LinkedList<Byte>();
        for (int i = 0; i < data.length - 1; ++i) {
            if ((data[i] & 0xFF) == 13) {
                packed.add((byte)64);
                packed.add((byte)-51);
                continue;
            }
            if ((data[i] & 0xFF) == 64) {
                packed.add((byte)64);
                packed.add((byte)0);
                continue;
            }
            packed.add(data[i]);
        }
        packed.add(data[data.length - 1]);
        return ByteUtils.convert(packed);
    }

    private byte[] unpack(List<Byte> data) {
        LinkedList<Byte> unpacked = new LinkedList<Byte>();
        for (int i = 0; i < data.size() - 1; ++i) {
            if ((data.get(i) & 0xFF) == 64) {
                if ((data.get(i + 1) & 0xFF) == 0) {
                    unpacked.add((byte)64);
                    ++i;
                    continue;
                }
                if ((data.get(i + 1) & 0xFF) == 205) {
                    unpacked.add((byte)13);
                    ++i;
                    continue;
                }
                unpacked.add(data.get(i));
                continue;
            }
            unpacked.add(data.get(i));
        }
        unpacked.add(data.get(data.size() - 1));
        return ByteUtils.convert(unpacked);
    }

    private byte getCrc(byte[] request) {
        int crc = 0;
        for (int i = 0; i < request.length - 2; ++i) {
            crc = crc + request[i] & 0xFF;
        }
        return (byte)(256 - crc);
    }
}

