/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.ldog;

import java.io.IOException;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.watchdog.ldog.LDogConnector;
import ru.softlogic.hardware.device.watchdog.ldog.LDogTimeouts;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class LDogApi
implements SerialDeviceApi {
    private final SerialPort port;
    private final LDogConnector connector;
    private final SerialParams[] params;

    public LDogApi(SerialPort port) {
        this.port = port;
        this.connector = new LDogConnector(port);
        this.params = new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)};
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (preferred) {
            for (SerialParams sp : this.params) {
                try {
                    this.port.putParams(sp);
                    this.port.open();
                    this.port.write(new byte[]{13, 13, 13});
                    this.getId();
                    DeviceType deviceType = null;
                    return deviceType;
                }
                catch (IOException iOException) {
                }
                finally {
                    this.port.close();
                }
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0443 " + this.port.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.LDog;
    }

    @Override
    public void open() throws IOException {
        this.port.open();
    }

    @Override
    public void close() {
        this.port.close();
    }

    public int getId() throws IOException {
        byte[] data = this.connector.sendCommand(17, null);
        return data[0] + (data[1] << 8) + (data[2] << 16) + (data[3] << 24);
    }

    public boolean resetModem() throws IOException {
        byte[] data = this.connector.sendCommand(1, null);
        return (data[0] & 0xFF) == 80;
    }

    public boolean resetPc() throws IOException {
        byte[] data = this.connector.sendCommand(0, null);
        return (data[0] & 0xFF) == 80;
    }

    public boolean startTimer() throws IOException {
        byte[] data = this.connector.sendCommand(3, null);
        return (data[0] & 0xFF) == 80;
    }

    public LDogTimeouts getTimeouts() throws IOException {
        byte[] data = this.connector.sendCommand(4, null);
        LDogTimeouts ldt = new LDogTimeouts();
        ldt.setStartTimeout((data[0] & 0xFF) + ((data[1] & 0xFF) << 8));
        ldt.setPingTimeout((data[2] & 0xFF) + ((data[3] & 0xFF) << 8));
        ldt.setResetPcTimeout((data[4] & 0xFF) + ((data[5] & 0xFF) << 8));
        ldt.setResetModemTimeout((data[6] & 0xFF) + ((data[7] & 0xFF) << 8));
        return ldt;
    }

    public boolean setTimeouts(LDogTimeouts ldt) throws IOException {
        byte[] timeouts = new byte[8];
        timeouts[1] = (byte)((ldt.getStartTimeout() & 0xFF00) >> 8);
        timeouts[0] = (byte)(ldt.getStartTimeout() & 0xFF);
        timeouts[3] = (byte)((ldt.getPingTimeout() & 0xFF00) >> 8);
        timeouts[2] = (byte)(ldt.getPingTimeout() & 0xFF);
        timeouts[5] = (byte)((ldt.getResetPcTimeout() & 0xFF00) >> 8);
        timeouts[4] = (byte)(ldt.getResetPcTimeout() & 0xFF);
        timeouts[7] = (byte)((ldt.getResetModemTimeout() & 0xFF00) >> 8);
        timeouts[6] = (byte)(ldt.getResetModemTimeout() & 0xFF);
        byte[] data = this.connector.sendCommand(5, timeouts);
        return (data[0] & 0xFF) == 80;
    }
}

