/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.karat;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.watchdog.BaseWatchDog;
import ru.softlogic.hardware.device.watchdog.karat.Karat1Api;
import ru.softlogic.io.serial.SerialPort;

public class Karat1WatchDog
extends BaseWatchDog {
    private final DeviceInfo info;
    private final Karat1Api api;
    private final Logger log = Logger.getLogger((String)"watchdog");

    public Karat1WatchDog(SerialPort port) {
        this.log.setAdditivity(false);
        this.api = new Karat1Api(port);
        this.info = new DeviceInfo(DeviceType.Karat1);
        this.info.setVendor("Karat2");
        this.info.setPort(port.getName());
    }

    @Override
    public void resetModem() throws IOException {
        try {
            this.api.open();
            this.api.modifyRelayMask(16);
            try {
                Thread.sleep(10000L);
                this.api.modifyRelayMask(255);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.api.close();
        }
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }
}

