/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.karat;

import java.io.IOException;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.utils.BU;

public class Karat1Api
implements SerialDeviceApi {
    private SerialPort serialPort;
    private SerialParams[] serialParams;

    public Karat1Api(SerialPort serialPort) {
        if (serialPort == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.serialPort = serialPort;
        this.serialPort.setTimeout(300);
        this.serialParams = new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)};
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return this.serialParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (preferred) {
            for (SerialParams params : this.getAvailableParameters()) {
                try {
                    this.serialPort.putParams(params);
                    this.open();
                    byte[] res = this.modifyRelayMask(16);
                    if (BU.c((byte)res[0]) != 240 || BU.c((byte)(res = this.modifyRelayMask(255))[0]) != 255) continue;
                    DeviceType deviceType = null;
                    return deviceType;
                }
                catch (Exception exception) {
                }
                finally {
                    this.close();
                }
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.serialPort.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.Karat1;
    }

    @Override
    public void open() throws IOException {
        this.serialPort.open();
    }

    @Override
    public void close() {
        this.serialPort.close();
    }

    public byte[] modifyRelayMask(int mask) throws IOException {
        this.serialPort.write(BU.c((int)mask));
        return this.serialPort.read(1);
    }
}

