/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.ciberpay;

import java.io.IOException;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.watchdog.BaseWatchDog;
import ru.softlogic.hardware.device.watchdog.ciberpay.StragGsmApi;

public class StragGsmWatchDog
extends BaseWatchDog {
    private StragGsmApi api;

    public StragGsmWatchDog(StragGsmApi api) {
        if (api == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 StragGsmApi");
        }
        this.api = api;
    }

    @Override
    public void resetModem() throws IOException {
        try {
            this.api.open();
            this.api.resetModem();
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            this.api.close();
        }
    }

    @Override
    public DeviceInfo getInfo() {
        try {
            this.api.look(true);
            DeviceInfo info = new DeviceInfo(DeviceType.StragGSM);
            info.setModel(this.api.getName());
            info.setPort("USB BUS");
            info.setVendor("CiberPay");
            return info;
        }
        catch (NoSuchDeviceException ex) {
            DeviceInfo info = new DeviceInfo(DeviceType.StragGSM);
            info.setModel(this.api.getName() + "/\u041d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d");
            info.setPort("---");
            info.setVendor("CiberPay");
            return info;
        }
    }
}

