/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.ciberpay;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.DeviceApi;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.device.DeviceType;

public abstract class StragGsmApi
implements DeviceApi {
    private final short idVendor;
    private final short idProduct;
    private final Logger log;

    public StragGsmApi(short idVendor, short idProduct) {
        this.idVendor = idVendor;
        this.idProduct = idProduct;
        this.log = Logger.getLogger((String)"watchdog");
    }

    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (preferred) {
            try {
                if (!this.lookNative(this.idVendor, this.idProduct)) {
                    throw new NoSuchDeviceException();
                }
            }
            catch (NoClassDefFoundError | UnsatisfiedLinkError ex) {
                throw new NoSuchDeviceException(ex);
            }
        }
        return null;
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.StragGSM;
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public void close() {
    }

    public void resetModem() throws IOException {
        try {
            this.resetModemNative(this.idVendor, this.idProduct);
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError ex) {
            throw new IOException(ex);
        }
    }

    public abstract String getName();

    private native boolean lookNative(int var1, int var2);

    private native void resetModemNative(int var1, int var2) throws IOException;

    static {
        System.loadLibrary("straggsm");
    }
}

