/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.avg2;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class Connection {
    private SerialPort port;
    private Logger log;

    public Connection(SerialPort port, Logger log) {
        if (port == null) {
            throw new NullPointerException("Port is not set");
        }
        if (log == null) {
            throw new NullPointerException("Logger is not set");
        }
        this.port = port;
        this.log = log;
    }

    public byte[] send(int cmd, byte[] data) throws IOException {
        IOException last = null;
        byte[] req = this.formMessage(cmd, data);
        this.port.setTimeout(1000);
        for (int i = 0; i < 3; ++i) {
            try {
                this.log.debug((Object)(">>" + BU.toString((byte[])req)));
                this.port.write(req);
                for (int j = 0; j < 50; ++j) {
                    int b1 = this.port.readByte();
                    if (b1 == 85) {
                        int b2 = this.port.readByte();
                        if (b2 == 170) {
                            int len = this.port.readByte();
                            this.log.debug((Object)("answer len: " + len));
                            byte[] oth = this.port.read(len - 3);
                            byte[] ans = new byte[len];
                            ans[0] = 85;
                            ans[1] = BU.c((int)170);
                            ans[2] = BU.c((int)len);
                            System.arraycopy(oth, 0, ans, 3, oth.length);
                            this.log.debug((Object)("<<" + BU.toString((byte[])ans)));
                            if (BU.c((byte)ans[ans.length - 1]) != this.calcCrc(ans)) {
                                throw new IOException("Crc is not correct: " + BU.toString((byte[])ans));
                            }
                            byte[] res = new byte[len - 4];
                            System.arraycopy(oth, 0, res, 0, oth.length - 1);
                            return res;
                        }
                        throw new IOException("Wrong sequence: 0x55 " + BU.toHex((int)b2));
                    }
                    this.log.error((Object)("Read spam: " + BU.toHex((int)b1)));
                }
                continue;
            }
            catch (IOException ex) {
                this.log.info((Object)("i/o error: " + ex.getMessage()));
                last = ex;
            }
        }
        throw last;
    }

    private byte[] formMessage(int cmd, byte[] data) {
        byte[] msg = new byte[5 + (data == null ? 0 : data.length)];
        msg[0] = 85;
        msg[1] = BU.c((int)170);
        msg[2] = BU.c((int)msg.length);
        msg[3] = BU.c((int)cmd);
        if (data != null) {
            System.arraycopy(data, 0, msg, 4, data.length);
        }
        msg[msg.length - 1] = this.calcCrc(msg);
        return msg;
    }

    private byte calcCrc(byte[] msg) {
        int res = 0;
        for (int i = 0; i < msg.length - 1; ++i) {
            res = res + BU.c((byte)msg[i]) & 0xFF;
        }
        return BU.c((int)res);
    }
}

