/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.avg2;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.watchdog.BaseWatchDog;
import ru.softlogic.hardware.device.watchdog.avg2.Avg2Api;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.system.util.ThreadUtil;

public class AvgWatchDog
extends BaseWatchDog {
    private Avg2Api api;
    private final Logger log = Logger.getLogger((String)"watchdog");
    private DeviceInfo info;

    public AvgWatchDog(SerialPort port) {
        if (port == null) {
            throw new NullPointerException("Port is not set");
        }
        this.api = new Avg2Api(port, this.log);
        this.info = new DeviceInfo(DeviceType.Avangard2);
        this.info.setVendor("\u0410\u0432\u0430\u043d\u0433\u0430\u0440\u0434");
        this.info.setPort(port.getName());
    }

    @Override
    public synchronized void resetModem() throws IOException {
        try {
            this.api.open();
            this.api.modemPowerOff();
            try {
                Thread.sleep(5000L);
                this.api.modemPowerOn();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.api.close();
        }
    }

    private synchronized void resetTimer() throws IOException {
        try {
            this.api.open();
            this.api.pingPc();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.api.close();
        }
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }

    private class WatchDogThread
    implements Runnable {
        private WatchDogThread() {
        }

        @Override
        public void run() {
            AvgWatchDog.this.log.info((Object)"Start thread");
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    AvgWatchDog.this.log.info((Object)"Ping watchdog");
                    AvgWatchDog.this.resetTimer();
                }
                catch (IOException ex) {
                    AvgWatchDog.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u0431\u0440\u043e\u0441\u0435 \u0442\u0430\u0439\u043c\u0435\u0440\u0430: ", (Throwable)ex);
                }
                ThreadUtil.sleep((long)10000L);
            }
            AvgWatchDog.this.log.info((Object)"Stop thread");
        }
    }
}

