/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.avg2;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.watchdog.avg2.Connection;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.utils.BU;

public class Avg2Api
implements SerialDeviceApi {
    public static final int ACK = 255;
    private SerialPort port;
    private Connection conn;
    private SerialParams[] params;
    private final Logger log = Logger.getLogger((String)"watchdog");

    public Avg2Api(SerialPort port, Logger log) {
        if (port == null) {
            throw new NullPointerException("Port is not set");
        }
        this.port = port;
        this.conn = new Connection(port, log);
        this.params = new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)};
    }

    @Override
    public void open() throws IOException {
        this.port.open();
    }

    @Override
    public void close() {
        this.port.close();
    }

    public int reboot() throws IOException {
        byte[] res = this.conn.send(2, null);
        return BU.c((byte)res[0]);
    }

    public int pingPc() throws IOException {
        byte[] res = this.conn.send(4, null);
        return BU.c((byte)res[0]);
    }

    public int pcPowerOff() throws IOException {
        byte[] res = this.conn.send(3, null);
        return BU.c((byte)res[0]);
    }

    public int modemPowerOff() throws IOException {
        byte[] res = this.conn.send(7, null);
        return BU.c((byte)res[0]);
    }

    public int modemPowerOn() throws IOException {
        byte[] res = this.conn.send(6, null);
        return BU.c((byte)res[0]);
    }

    public int getState() throws IOException {
        byte[] res = this.conn.send(1, null);
        this.log.debug((Object)BU.toString((byte[])res));
        return BU.c((byte)res[0]);
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (preferred) {
            for (SerialParams p : this.getAvailableParameters()) {
                try {
                    this.port.putParams(p);
                    this.open();
                    this.getState();
                    DeviceType deviceType = null;
                    return deviceType;
                }
                catch (Exception exception) {
                }
                finally {
                    this.close();
                }
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.port.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.Avangard2;
    }
}

