/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.avangard;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class AvangardApi
implements SerialDeviceApi {
    private static final byte START = -38;
    private SerialPort port;
    private SerialParams[] params;
    private Logger log;

    public AvangardApi(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.port = port;
        this.params = new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)};
        this.log = Logger.getLogger((String)"watchdog");
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (preferred) {
            for (SerialParams param : this.params) {
                try {
                    this.port.putParams(param);
                    this.port.open();
                    this.getName();
                    DeviceType deviceType = null;
                    return deviceType;
                }
                catch (IOException iOException) {
                }
                finally {
                    this.port.close();
                }
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0443 " + this.port.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.Avangard;
    }

    @Override
    public void open() throws IOException {
        this.port.open();
    }

    @Override
    public void close() {
        this.port.close();
    }

    public String getName() throws IOException {
        this.sendCommand((byte)1, null, false);
        return null;
    }

    public int getSwitches() throws IOException {
        byte[] res = this.sendCommand((byte)2, null, true);
        return res[0] & 0xFF;
    }

    public int setModemTimeout(int value) throws IOException {
        byte[] data = new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        byte[] res = this.sendCommand((byte)3, data, true);
        return res[1] & 0xFF;
    }

    public int resetModem() throws IOException {
        byte[] res = this.sendCommand((byte)4, null, true);
        return res[1] & 0xFF;
    }

    public int resetPc() throws IOException {
        byte[] res = this.sendCommand((byte)5, null, true);
        return res[1] & 0xFF;
    }

    public void resetDevice() throws IOException {
        this.sendCommand((byte)12, null, true);
    }

    public int setBeepTimeout(int timeout) throws IOException {
        if (timeout < 0 || timeout > 255) {
            throw new IllegalArgumentException("\u0422\u0430\u0439\u043c\u0430\u0443\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043e\u0442 1 \u0434\u043e 255 \u0441\u0435\u043a\u0443\u043d\u0434");
        }
        byte[] res = this.sendCommand((byte)10, new byte[]{(byte)(timeout & 0xFF)}, true);
        return res[1] & 0xFF;
    }

    public int beep() throws IOException {
        byte[] res = this.sendCommand((byte)11, null, true);
        return res[1] & 0xFF;
    }

    public int hasGood(int section) throws IOException {
        if (section < 0 || section > 3) {
            throw new IllegalArgumentException("\u041d\u043e\u043c\u0435\u0440 \u0441\u0435\u043a\u0446\u0438\u0438 \u043e\u0442 0 \u0434\u043e 3");
        }
        byte[] res = this.sendCommand((byte)(17 + section), null, true);
        return res[1] & 0xFF;
    }

    public int sellGood(int section) throws IOException {
        if (section < 0 || section > 3) {
            throw new IllegalArgumentException("\u041d\u043e\u043c\u0435\u0440 \u0441\u0435\u043a\u0446\u0438\u0438 \u043e\u0442 0 \u0434\u043e 3");
        }
        byte[] res = this.sendCommand((byte)(33 + section), null, true);
        return res[1] & 0xFF;
    }

    public int checkSellGood(int section) throws IOException {
        if (section < 0 || section > 3) {
            throw new IllegalArgumentException("\u041d\u043e\u043c\u0435\u0440 \u0441\u0435\u043a\u0446\u0438\u0438 \u043e\u0442 0 \u0434\u043e 3");
        }
        byte[] res = this.sendCommand((byte)(49 + section), null, true);
        return res[1] & 0xFF;
    }

    public int turnOnRelay(int num) throws IOException {
        if (num < 0 || num > 3) {
            throw new IllegalArgumentException("\u041d\u043e\u043c\u0435\u0440 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043e\u0442 0 \u0434\u043e 3");
        }
        byte[] res = this.sendCommand((byte)(6 + num), null, true);
        return res[1] & 0xFF;
    }

    private byte[] sendCommand(byte cmd, byte[] data, boolean skipName) throws IOException {
        int rdata2;
        byte[] request = new byte[4 + (data == null ? 0 : data.length)];
        request[0] = -38;
        request[1] = (byte)request.length;
        request[2] = cmd;
        if (data != null) {
            System.arraycopy(data, 0, request, 3, data.length);
        }
        byte crc = 0;
        for (int i = 0; i < request.length - 1; ++i) {
            crc = (byte)(crc + request[i]);
        }
        request[request.length - 1] = crc;
        this.log.info((Object)(">> " + ByteUtils.toString(request)));
        this.port.setTimeout(2000);
        this.port.write(request);
        int k = 0;
        do {
            rdata2 = this.port.readByte();
            this.log.info((Object)("\u041f\u0440\u043e\u0447\u0438\u0442\u0430\u043b\u0438: " + String.format("0x%02x", rdata2)));
            if (++k > 20) {
                throw new IOException("\u0421\u0442\u0430\u0440\u0442\u043e\u0432\u044b\u0439 \u0431\u0430\u0439\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            this.log.debug((Object)("rdata2!=Start: " + (rdata2 != -38)));
        } while (rdata2 != 218);
        this.log.info((Object)"\u0421\u0442\u0430\u0440\u0442\u043e\u0432\u044b\u0439 \u0431\u0430\u0439\u0442 \u043d\u0430\u0439\u0434\u0435\u043d");
        int start = -38;
        byte len = this.port.read(1)[0];
        this.log.info((Object)("\u0414\u043b\u0438\u043d\u0430 \u043e\u0442\u0432\u0435\u0442\u0430: " + len));
        if (len < 4) {
            throw new IOException("\u041e\u0442\u0432\u0435\u0442 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043a\u043e\u0440\u043e\u0442\u043a\u0438\u0439");
        }
        byte[] rdata = this.port.read(len - 3);
        byte crc2 = this.port.read(1)[0];
        this.log.info((Object)"<<");
        this.log.info((Object)String.format("0x%02x", (byte)-38));
        this.log.info((Object)String.format("0x%02x", len));
        this.log.info((Object)ByteUtils.toString(rdata));
        this.log.info((Object)String.format("0x%02x", crc2));
        crc = -38;
        crc = (byte)(crc + len);
        for (int i = 0; i < rdata.length; ++i) {
            if (skipName && (rdata[i] & 0xFF) == 159) continue;
            crc = (byte)(crc + (rdata[i] & 0xFF));
        }
        if (crc2 != crc) {
            throw new IOException("\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043d\u0435 \u0441\u0445\u043e\u0434\u0438\u0442\u0441\u044f");
        }
        return rdata;
    }
}

