/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.alarm;

import java.io.IOException;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class AlarmApi
implements SerialDeviceApi {
    public static final int SWITCH_SAFE = 1;
    public static final int SWITCH_TOP_BOX = 2;
    public static final int SWITCH_BOTTOM_BOX = 4;
    public static final int SWITCH_TILT = 32;
    public static final int SWITCH_BURST = 64;
    private SerialPort serialPort;
    private SerialParams[] params;

    public AlarmApi(SerialPort serialPort) {
        if (serialPort == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        serialPort.setTimeout(300);
        this.serialPort = serialPort;
        this.params = new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)};
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (preferred) {
            for (SerialParams p : this.getAvailableParameters()) {
                try {
                    int channel;
                    this.serialPort.putParams(p);
                    this.open();
                    int dev = this.getDeviceState();
                    if ((dev | 0x1F) != 31 || ((channel = this.getChannelState()) & 0xF0) != 192) continue;
                    DeviceType deviceType = null;
                    return deviceType;
                }
                catch (Exception exception) {
                }
                finally {
                    this.close();
                }
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.serialPort.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.Alarm;
    }

    @Override
    public void open() throws IOException {
        this.serialPort.putParams(new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None));
        this.serialPort.open();
        this.serialPort.setFlow(Flow.None);
    }

    @Override
    public void close() {
        this.serialPort.close();
    }

    public void lockSafe() throws IOException {
        this.serialPort.write((byte)-126);
    }

    public void unlockSafe() throws IOException {
        this.serialPort.write((byte)-127);
    }

    public void resetModem() throws IOException {
        this.serialPort.write((byte)-124);
    }

    public void startTimer() throws IOException {
        this.serialPort.write((byte)-120);
    }

    public Integer getSwitchState() throws IOException {
        if (this.serialPort.avaliable() > 0) {
            return this.serialPort.readByte();
        }
        return null;
    }

    public int getDeviceState() throws IOException {
        this.serialPort.flush(Flush.RxTx);
        this.serialPort.write((byte)-128);
        return this.serialPort.readByte();
    }

    public int getChannelState() throws IOException {
        this.serialPort.flush(Flush.RxTx);
        this.serialPort.write((byte)-64);
        return this.serialPort.readByte();
    }
}

