/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog;

import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.watchdog.WatchDog;
import ru.softlogic.hardware.device.watchdog.WatchDogDescriptor;
import ru.softlogic.hardware.device.watchdog.WatchDogSettings;
import ru.softlogic.hardware.device.watchdog.alarm.AlarmWatchDog;
import ru.softlogic.hardware.device.watchdog.alarm.AlarmWatchDogDescriptor;
import ru.softlogic.hardware.device.watchdog.avangard.AvangardWatchDog;
import ru.softlogic.hardware.device.watchdog.avg2.AvgWatchDog;
import ru.softlogic.hardware.device.watchdog.ciberpay.StragGsm11Api;
import ru.softlogic.hardware.device.watchdog.ciberpay.StragGsm12Api;
import ru.softlogic.hardware.device.watchdog.ciberpay.StragGsmWatchDog;
import ru.softlogic.hardware.device.watchdog.external.ExternalWatchDog;
import ru.softlogic.hardware.device.watchdog.karat.Karat1WatchDog;
import ru.softlogic.hardware.device.watchdog.karat.Karat2WatchDog;
import ru.softlogic.hardware.device.watchdog.ldog.LDogWatchDog;
import ru.softlogic.hardware.device.watchdog.online.OnlineWatchDog;
import ru.softlogic.hardware.device.watchdog.osmp.OsmpWatchDog;
import ru.softlogic.hardware.device.watchdog.sapfir.SapfirWatchDog;
import ru.softlogic.hardware.device.watchdog.simple.SimpleWathDog;
import ru.softlogic.hardware.device.watchdog.softlogic.SoftLogicWatchDog;
import ru.softlogic.hardware.device.watchdog.software.SoftwareWatchDog;
import ru.softlogic.io.serial.SerialPort;

public class WatchDogFactory {
    public static WatchDog createInstance() {
        Logger log = Logger.getLogger((String)"watchdog");
        try {
            try {
                StragGsm11Api api = new StragGsm11Api();
                api.look(true);
                log.info((Object)"\u0422\u0430\u0439\u043c\u0435\u0440 \u0421\u0442\u0440\u0430\u0436 GSM 1.1 \u043d\u0430\u0439\u0434\u0435\u043d");
                return new StragGsmWatchDog(api);
            }
            catch (NoSuchDeviceException ex) {
                log.info((Object)"\u0422\u0430\u0439\u043c\u0435\u0440 \u0421\u0442\u0440\u0430\u0436 GSM 1.1 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                try {
                    StragGsm12Api api = new StragGsm12Api();
                    api.look(true);
                    log.info((Object)"\u0422\u0430\u0439\u043c\u0435\u0440 \u0421\u0442\u0440\u0430\u0436 GSM 1.2 \u043d\u0430\u0439\u0434\u0435\u043d");
                    return new StragGsmWatchDog(api);
                }
                catch (NoSuchDeviceException ex2) {
                    log.info((Object)"\u0422\u0430\u0439\u043c\u0435\u0440 \u0421\u0442\u0440\u0430\u0436 GSM 1.2 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                }
            }
        }
        catch (Throwable ex) {
            log.error((Object)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 \u0434\u043b\u044f StragGSM");
        }
        return null;
    }

    public static WatchDog createInstance(DeviceType type, SerialPort serialPort, WatchDogSettings settings) {
        if (type == null || serialPort == null) {
            return null;
        }
        WatchDog watchDog = null;
        switch (type.getDeviceClass()) {
            case WatchDog: {
                switch (type) {
                    case Osmp: {
                        watchDog = new OsmpWatchDog(serialPort);
                        break;
                    }
                    case Online: {
                        watchDog = new OnlineWatchDog(serialPort);
                        break;
                    }
                    case Software: {
                        watchDog = WatchDogFactory.createInstance();
                        if (watchDog != null) break;
                        watchDog = new SoftwareWatchDog(serialPort);
                        break;
                    }
                    case SimpleRTS: {
                        watchDog = new SimpleWathDog(serialPort);
                        break;
                    }
                    case SoftLogic: {
                        watchDog = new SoftLogicWatchDog(serialPort);
                        break;
                    }
                    case Alarm: {
                        watchDog = new AlarmWatchDog(serialPort, settings);
                        break;
                    }
                    case Avangard: {
                        watchDog = new AvangardWatchDog(serialPort);
                        break;
                    }
                    case External: {
                        watchDog = new ExternalWatchDog(settings);
                        break;
                    }
                    case Sapfir: {
                        watchDog = new SapfirWatchDog(serialPort);
                        break;
                    }
                    case LDog: {
                        watchDog = new LDogWatchDog(serialPort);
                        break;
                    }
                    case Karat1: {
                        watchDog = new Karat1WatchDog(serialPort);
                        break;
                    }
                    case Karat2: {
                        watchDog = new Karat2WatchDog(serialPort);
                        break;
                    }
                    case Avangard2: {
                        watchDog = new AvgWatchDog(serialPort);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0438\u043f");
            }
        }
        return watchDog;
    }

    public static WatchDogDescriptor createDescriptor(DeviceType type) {
        WatchDogDescriptor wds = null;
        block0 : switch (type.getDeviceClass()) {
            case WatchDog: {
                switch (type) {
                    case Alarm: {
                        wds = new AlarmWatchDogDescriptor();
                        break block0;
                    }
                }
                wds = new WatchDogDescriptor();
                break;
            }
            default: {
                throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0438\u043f");
            }
        }
        return wds;
    }
}

