/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.scanner.metrologic;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.system.util.ArrayUtils;

public class MetroLogicApi
implements SerialDeviceApi {
    private final SerialPort port;
    private final Map<Boolean, SerialParams[]> serialParams;
    private final Logger log;

    public MetroLogicApi(SerialPort port) {
        this.port = port;
        this.serialParams = new HashMap<Boolean, SerialParams[]>();
        this.serialParams.put(Boolean.TRUE, new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)});
        this.serialParams.put(Boolean.FALSE, new SerialParams[]{new SerialParams(4800, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.None)});
        this.log = Logger.getLogger((String)"barcode");
        this.log.setAdditivity(false);
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return (SerialParams[])ArrayUtils.arrayMerge((Object[][])new SerialParams[][]{this.serialParams.get(true), this.serialParams.get(false)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        for (SerialParams params : this.serialParams.get(preferred)) {
            try {
                this.log.info((Object)(this.port.getName() + " search metrologic scanner: " + params));
                this.port.putParams(params);
                this.port.open();
                this.port.write(new byte[]{2, 57, 57, 57, 57, 57, 57, 3});
                int res = this.port.readByte();
                if (res != 6 && res != 21 || this.port.avaliable() != 0) continue;
                this.port.write(new byte[]{2, 57, 57, 57, 57, 57, 57, 3});
                DeviceType deviceType = null;
                return deviceType;
            }
            catch (Exception ex) {
                this.log.error((Object)(this.port.getName() + " Not found"));
            }
            finally {
                this.port.close();
            }
        }
        throw new NoSuchDeviceException("Device on port " + this.port.getName() + " is not " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.MetrologicScanner;
    }

    @Override
    public void open() throws IOException {
        this.port.open();
    }

    @Override
    public void close() {
        this.port.close();
    }
}

